/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.MediaJobState;
import com.azure.messaging.eventgrid.systemevents.MediaJobStateChangeEventData;
import java.io.IOException;
import java.util.Map;

public final class MediaJobScheduledEventData
extends MediaJobStateChangeEventData {
    private MediaJobState state;
    private MediaJobState previousState;

    @Override
    public MediaJobState getState() {
        return this.state;
    }

    @Override
    public MediaJobState getPreviousState() {
        return this.previousState;
    }

    @Override
    public MediaJobScheduledEventData setCorrelationData(Map<String, String> correlationData) {
        super.setCorrelationData(correlationData);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("correlationData", this.getCorrelationData(), (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static MediaJobScheduledEventData fromJson(JsonReader jsonReader) throws IOException {
        return (MediaJobScheduledEventData)jsonReader.readObject(reader -> {
            MediaJobScheduledEventData deserializedMediaJobScheduledEventData = new MediaJobScheduledEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("previousState".equals(fieldName)) {
                    deserializedMediaJobScheduledEventData.previousState = MediaJobState.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMediaJobScheduledEventData.state = MediaJobState.fromString(reader.getString());
                    continue;
                }
                if ("correlationData".equals(fieldName)) {
                    Map correlationData = reader.readMap(reader1 -> reader1.getString());
                    deserializedMediaJobScheduledEventData.setCorrelationData(correlationData);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMediaJobScheduledEventData;
        });
    }
}

