/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public final class MediaLiveEventChannelArchiveHeartbeatEventData
implements JsonSerializable<MediaLiveEventChannelArchiveHeartbeatEventData> {
    private String channelLatencyMs;
    private String latencyResultCode;
    private static final ClientLogger LOGGER = new ClientLogger(MediaLiveEventChannelArchiveHeartbeatEventData.class);

    public Duration getChannelLatency() {
        Long channelLatencyMsLong;
        if ("n/a".equals(this.channelLatencyMs)) {
            return null;
        }
        try {
            channelLatencyMsLong = Long.parseLong(this.channelLatencyMs);
        }
        catch (NumberFormatException ex) {
            LOGGER.logExceptionAsError((RuntimeException)ex);
            return null;
        }
        return Duration.ofMillis(channelLatencyMsLong);
    }

    public String getLatencyResultCode() {
        return this.latencyResultCode;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static MediaLiveEventChannelArchiveHeartbeatEventData fromJson(JsonReader jsonReader) throws IOException {
        return (MediaLiveEventChannelArchiveHeartbeatEventData)jsonReader.readObject(reader -> {
            MediaLiveEventChannelArchiveHeartbeatEventData deserializedMediaLiveEventChannelArchiveHeartbeatEventData = new MediaLiveEventChannelArchiveHeartbeatEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("channelLatencyMs".equals(fieldName)) {
                    deserializedMediaLiveEventChannelArchiveHeartbeatEventData.channelLatencyMs = reader.getString();
                    continue;
                }
                if ("latencyResultCode".equals(fieldName)) {
                    deserializedMediaLiveEventChannelArchiveHeartbeatEventData.latencyResultCode = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMediaLiveEventChannelArchiveHeartbeatEventData;
        });
    }
}

