/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatThreadEventInThreadBaseProperties;
import com.azure.messaging.eventgrid.systemevents.AcsChatThreadParticipantProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class AcsChatThreadCreatedEventData
extends AcsChatThreadEventInThreadBaseProperties {
    private CommunicationIdentifierModel createdByCommunicationIdentifier;
    private Map<String, Object> properties;
    private Map<String, String> metadata;
    private List<AcsChatThreadParticipantProperties> participants;

    public CommunicationIdentifierModel getCreatedByCommunicationIdentifier() {
        return this.createdByCommunicationIdentifier;
    }

    public AcsChatThreadCreatedEventData setCreatedByCommunicationIdentifier(CommunicationIdentifierModel createdByCommunicationIdentifier) {
        this.createdByCommunicationIdentifier = createdByCommunicationIdentifier;
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public AcsChatThreadCreatedEventData setProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public AcsChatThreadCreatedEventData setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<AcsChatThreadParticipantProperties> getParticipants() {
        return this.participants;
    }

    public AcsChatThreadCreatedEventData setParticipants(List<AcsChatThreadParticipantProperties> participants) {
        this.participants = participants;
        return this;
    }

    @Override
    public AcsChatThreadCreatedEventData setCreateTime(OffsetDateTime createTime) {
        super.setCreateTime(createTime);
        return this;
    }

    @Override
    public AcsChatThreadCreatedEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AcsChatThreadCreatedEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatThreadCreatedEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeStringField("createTime", this.getCreateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getCreateTime()));
        jsonWriter.writeNumberField("version", (Number)this.getVersion());
        jsonWriter.writeJsonField("createdByCommunicationIdentifier", (JsonSerializable)this.createdByCommunicationIdentifier);
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("participants", this.participants, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AcsChatThreadCreatedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatThreadCreatedEventData)jsonReader.readObject(reader -> {
            AcsChatThreadCreatedEventData deserializedAcsChatThreadCreatedEventData = new AcsChatThreadCreatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatThreadCreatedEventData.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatThreadCreatedEventData.setThreadId(reader.getString());
                    continue;
                }
                if ("createTime".equals(fieldName)) {
                    deserializedAcsChatThreadCreatedEventData.setCreateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatThreadCreatedEventData.setVersion((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("createdByCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatThreadCreatedEventData.createdByCommunicationIdentifier = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedAcsChatThreadCreatedEventData.properties = properties = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedAcsChatThreadCreatedEventData.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("participants".equals(fieldName)) {
                    List participants;
                    deserializedAcsChatThreadCreatedEventData.participants = participants = reader.readArray(reader1 -> AcsChatThreadParticipantProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatThreadCreatedEventData;
        });
    }
}

