// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of calling event reason properties.
 */
@Fluent
public final class AcsCallEndReasonProperties implements JsonSerializable<AcsCallEndReasonProperties> {
    /*
     * Reason code for ending the call.
     */
    private Integer code;

    /*
     * Reason subcode for ending the call.
     */
    private Integer subCode;

    /*
     * Reason for ending the call.
     */
    private String phrase;

    /**
     * Creates an instance of AcsCallEndReasonProperties class.
     */
    public AcsCallEndReasonProperties() {
    }

    /**
     * Get the code property: Reason code for ending the call.
     * 
     * @return the code value.
     */
    public Integer getCode() {
        return this.code;
    }

    /**
     * Set the code property: Reason code for ending the call.
     * 
     * @param code the code value to set.
     * @return the AcsCallEndReasonProperties object itself.
     */
    public AcsCallEndReasonProperties setCode(Integer code) {
        this.code = code;
        return this;
    }

    /**
     * Get the subCode property: Reason subcode for ending the call.
     * 
     * @return the subCode value.
     */
    public Integer getSubCode() {
        return this.subCode;
    }

    /**
     * Set the subCode property: Reason subcode for ending the call.
     * 
     * @param subCode the subCode value to set.
     * @return the AcsCallEndReasonProperties object itself.
     */
    public AcsCallEndReasonProperties setSubCode(Integer subCode) {
        this.subCode = subCode;
        return this;
    }

    /**
     * Get the phrase property: Reason for ending the call.
     * 
     * @return the phrase value.
     */
    public String getPhrase() {
        return this.phrase;
    }

    /**
     * Set the phrase property: Reason for ending the call.
     * 
     * @param phrase the phrase value to set.
     * @return the AcsCallEndReasonProperties object itself.
     */
    public AcsCallEndReasonProperties setPhrase(String phrase) {
        this.phrase = phrase;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("code", this.code);
        jsonWriter.writeNumberField("subCode", this.subCode);
        jsonWriter.writeStringField("phrase", this.phrase);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsCallEndReasonProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsCallEndReasonProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsCallEndReasonProperties.
     */
    public static AcsCallEndReasonProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsCallEndReasonProperties deserializedAcsCallEndReasonProperties = new AcsCallEndReasonProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedAcsCallEndReasonProperties.code = reader.getNullable(JsonReader::getInt);
                } else if ("subCode".equals(fieldName)) {
                    deserializedAcsCallEndReasonProperties.subCode = reader.getNullable(JsonReader::getInt);
                } else if ("phrase".equals(fieldName)) {
                    deserializedAcsCallEndReasonProperties.phrase = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsCallEndReasonProperties;
        });
    }
}
