// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The type of the call ended by.
 */
public final class AcsCallEndedByKind extends ExpandableStringEnum<AcsCallEndedByKind> {
    /**
     * Call end initiator is a participant.
     */
    public static final AcsCallEndedByKind PARTICIPANT = fromString("Participant");

    /**
     * Call end initiator is the local participant.
     */
    public static final AcsCallEndedByKind MICROSOFT_INTERNAL = fromString("MicrosoftInternal");

    /**
     * Creates a new instance of AcsCallEndedByKind value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AcsCallEndedByKind() {
    }

    /**
     * Creates or finds a AcsCallEndedByKind from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AcsCallEndedByKind.
     */
    public static AcsCallEndedByKind fromString(String name) {
        return fromString(name, AcsCallEndedByKind.class);
    }

    /**
     * Gets known AcsCallEndedByKind values.
     * 
     * @return known AcsCallEndedByKind values.
     */
    public static Collection<AcsCallEndedByKind> values() {
        return values(AcsCallEndedByKind.class);
    }
}
