// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of calling event group properties.
 */
@Fluent
public final class AcsCallGroupProperties implements JsonSerializable<AcsCallGroupProperties> {
    /*
     * Group Id. Format is Guid as string.
     */
    private String id;

    /**
     * Creates an instance of AcsCallGroupProperties class.
     */
    public AcsCallGroupProperties() {
    }

    /**
     * Get the id property: Group Id. Format is Guid as string.
     * 
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: Group Id. Format is Guid as string.
     * 
     * @param id the id value to set.
     * @return the AcsCallGroupProperties object itself.
     */
    public AcsCallGroupProperties setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsCallGroupProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsCallGroupProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsCallGroupProperties.
     */
    public static AcsCallGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsCallGroupProperties deserializedAcsCallGroupProperties = new AcsCallGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAcsCallGroupProperties.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsCallGroupProperties;
        });
    }
}
