// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The role of participant user.
 */
public final class AcsCallParticipantKind extends ExpandableStringEnum<AcsCallParticipantKind> {
    /**
     * Call participant role is an attendee.
     */
    public static final AcsCallParticipantKind ATTENDEE = fromString("Attendee");

    /**
     * Call participant role is presenter.
     */
    public static final AcsCallParticipantKind PRESENTER = fromString("Presenter");

    /**
     * Call participant role is consumer.
     */
    public static final AcsCallParticipantKind CONSUMER = fromString("Consumer");

    /**
     * Call participant role is collaborator.
     */
    public static final AcsCallParticipantKind COLLABORATOR = fromString("Collaborator");

    /**
     * Call participant role is organizer.
     */
    public static final AcsCallParticipantKind ORGANIZER = fromString("Organizer");

    /**
     * Creates a new instance of AcsCallParticipantKind value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AcsCallParticipantKind() {
    }

    /**
     * Creates or finds a AcsCallParticipantKind from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AcsCallParticipantKind.
     */
    public static AcsCallParticipantKind fromString(String name) {
        return fromString(name, AcsCallParticipantKind.class);
    }

    /**
     * Gets known AcsCallParticipantKind values.
     * 
     * @return known AcsCallParticipantKind values.
     */
    public static Collection<AcsCallParticipantKind> values() {
        return values(AcsCallParticipantKind.class);
    }
}
