// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of calling event participant user.
 */
@Fluent
public final class AcsCallParticipantProperties implements JsonSerializable<AcsCallParticipantProperties> {
    /*
     * The communication identifier of the call ended by
     */
    private CommunicationIdentifierModel communicationIdentifier;

    /*
     * The role of participant user.
     */
    private AcsCallParticipantKind role;

    /**
     * Creates an instance of AcsCallParticipantProperties class.
     */
    public AcsCallParticipantProperties() {
    }

    /**
     * Get the communicationIdentifier property: The communication identifier of the call ended by.
     * 
     * @return the communicationIdentifier value.
     */
    public CommunicationIdentifierModel getCommunicationIdentifier() {
        return this.communicationIdentifier;
    }

    /**
     * Set the communicationIdentifier property: The communication identifier of the call ended by.
     * 
     * @param communicationIdentifier the communicationIdentifier value to set.
     * @return the AcsCallParticipantProperties object itself.
     */
    public AcsCallParticipantProperties
        setCommunicationIdentifier(CommunicationIdentifierModel communicationIdentifier) {
        this.communicationIdentifier = communicationIdentifier;
        return this;
    }

    /**
     * Get the role property: The role of participant user.
     * 
     * @return the role value.
     */
    public AcsCallParticipantKind getRole() {
        return this.role;
    }

    /**
     * Set the role property: The role of participant user.
     * 
     * @param role the role value to set.
     * @return the AcsCallParticipantProperties object itself.
     */
    public AcsCallParticipantProperties setRole(AcsCallParticipantKind role) {
        this.role = role;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("communicationIdentifier", this.communicationIdentifier);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsCallParticipantProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsCallParticipantProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsCallParticipantProperties.
     */
    public static AcsCallParticipantProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsCallParticipantProperties deserializedAcsCallParticipantProperties = new AcsCallParticipantProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("communicationIdentifier".equals(fieldName)) {
                    deserializedAcsCallParticipantProperties.communicationIdentifier
                        = CommunicationIdentifierModel.fromJson(reader);
                } else if ("role".equals(fieldName)) {
                    deserializedAcsCallParticipantProperties.role
                        = AcsCallParticipantKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsCallParticipantProperties;
        });
    }
}
