// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.CallStarted event.
 */
@Fluent
public final class AcsCallStartedEventData extends AcsCallingEventProperties {
    /**
     * Creates an instance of AcsCallStartedEventData class.
     */
    public AcsCallStartedEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsCallStartedEventData setStartedBy(AcsCallParticipantProperties startedBy) {
        super.setStartedBy(startedBy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsCallStartedEventData setServerCallId(String serverCallId) {
        super.setServerCallId(serverCallId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsCallStartedEventData setGroup(AcsCallGroupProperties group) {
        super.setGroup(group);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsCallStartedEventData setRoom(AcsCallRoomProperties room) {
        super.setRoom(room);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsCallStartedEventData setIsTwoParty(Boolean isTwoParty) {
        super.setIsTwoParty(isTwoParty);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsCallStartedEventData setCorrelationId(String correlationId) {
        super.setCorrelationId(correlationId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsCallStartedEventData setIsRoomsCall(Boolean isRoomsCall) {
        super.setIsRoomsCall(isRoomsCall);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("startedBy", getStartedBy());
        jsonWriter.writeStringField("serverCallId", getServerCallId());
        jsonWriter.writeStringField("correlationId", getCorrelationId());
        jsonWriter.writeJsonField("group", getGroup());
        jsonWriter.writeJsonField("room", getRoom());
        jsonWriter.writeBooleanField("isTwoParty", isTwoParty());
        jsonWriter.writeBooleanField("isRoomsCall", isRoomsCall());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsCallStartedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsCallStartedEventData if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsCallStartedEventData.
     */
    public static AcsCallStartedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsCallStartedEventData deserializedAcsCallStartedEventData = new AcsCallStartedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("startedBy".equals(fieldName)) {
                    deserializedAcsCallStartedEventData.setStartedBy(AcsCallParticipantProperties.fromJson(reader));
                } else if ("serverCallId".equals(fieldName)) {
                    deserializedAcsCallStartedEventData.setServerCallId(reader.getString());
                } else if ("correlationId".equals(fieldName)) {
                    deserializedAcsCallStartedEventData.setCorrelationId(reader.getString());
                } else if ("group".equals(fieldName)) {
                    deserializedAcsCallStartedEventData.setGroup(AcsCallGroupProperties.fromJson(reader));
                } else if ("room".equals(fieldName)) {
                    deserializedAcsCallStartedEventData.setRoom(AcsCallRoomProperties.fromJson(reader));
                } else if ("isTwoParty".equals(fieldName)) {
                    deserializedAcsCallStartedEventData.setIsTwoParty(reader.getNullable(JsonReader::getBoolean));
                } else if ("isRoomsCall".equals(fieldName)) {
                    deserializedAcsCallStartedEventData.setIsRoomsCall(reader.getNullable(JsonReader::getBoolean));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsCallStartedEventData;
        });
    }
}
