// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of common properties of all calling events.
 */
@Fluent
public class AcsCallingEventProperties implements JsonSerializable<AcsCallingEventProperties> {
    /*
     * The call participant who initiated the call.
     */
    private AcsCallParticipantProperties startedBy;

    /*
     * The callId of the server
     */
    private String serverCallId;

    /*
     * The group metadata
     */
    private AcsCallGroupProperties group;

    /*
     * The group metadata
     */
    private AcsCallRoomProperties room;

    /*
     * Is two-party in calling event.
     */
    private Boolean isTwoParty;

    /*
     * The correlation ID of the calling event
     */
    private String correlationId;

    /*
     * Is the calling event a room call.
     */
    private Boolean isRoomsCall;

    /**
     * Creates an instance of AcsCallingEventProperties class.
     */
    public AcsCallingEventProperties() {
    }

    /**
     * Get the startedBy property: The call participant who initiated the call.
     * 
     * @return the startedBy value.
     */
    public AcsCallParticipantProperties getStartedBy() {
        return this.startedBy;
    }

    /**
     * Set the startedBy property: The call participant who initiated the call.
     * 
     * @param startedBy the startedBy value to set.
     * @return the AcsCallingEventProperties object itself.
     */
    public AcsCallingEventProperties setStartedBy(AcsCallParticipantProperties startedBy) {
        this.startedBy = startedBy;
        return this;
    }

    /**
     * Get the serverCallId property: The callId of the server.
     * 
     * @return the serverCallId value.
     */
    public String getServerCallId() {
        return this.serverCallId;
    }

    /**
     * Set the serverCallId property: The callId of the server.
     * 
     * @param serverCallId the serverCallId value to set.
     * @return the AcsCallingEventProperties object itself.
     */
    public AcsCallingEventProperties setServerCallId(String serverCallId) {
        this.serverCallId = serverCallId;
        return this;
    }

    /**
     * Get the group property: The group metadata.
     * 
     * @return the group value.
     */
    public AcsCallGroupProperties getGroup() {
        return this.group;
    }

    /**
     * Set the group property: The group metadata.
     * 
     * @param group the group value to set.
     * @return the AcsCallingEventProperties object itself.
     */
    public AcsCallingEventProperties setGroup(AcsCallGroupProperties group) {
        this.group = group;
        return this;
    }

    /**
     * Get the room property: The group metadata.
     * 
     * @return the room value.
     */
    public AcsCallRoomProperties getRoom() {
        return this.room;
    }

    /**
     * Set the room property: The group metadata.
     * 
     * @param room the room value to set.
     * @return the AcsCallingEventProperties object itself.
     */
    public AcsCallingEventProperties setRoom(AcsCallRoomProperties room) {
        this.room = room;
        return this;
    }

    /**
     * Get the isTwoParty property: Is two-party in calling event.
     * 
     * @return the isTwoParty value.
     */
    public Boolean isTwoParty() {
        return this.isTwoParty;
    }

    /**
     * Set the isTwoParty property: Is two-party in calling event.
     * 
     * @param isTwoParty the isTwoParty value to set.
     * @return the AcsCallingEventProperties object itself.
     */
    public AcsCallingEventProperties setIsTwoParty(Boolean isTwoParty) {
        this.isTwoParty = isTwoParty;
        return this;
    }

    /**
     * Get the correlationId property: The correlation ID of the calling event.
     * 
     * @return the correlationId value.
     */
    public String getCorrelationId() {
        return this.correlationId;
    }

    /**
     * Set the correlationId property: The correlation ID of the calling event.
     * 
     * @param correlationId the correlationId value to set.
     * @return the AcsCallingEventProperties object itself.
     */
    public AcsCallingEventProperties setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    /**
     * Get the isRoomsCall property: Is the calling event a room call.
     * 
     * @return the isRoomsCall value.
     */
    public Boolean isRoomsCall() {
        return this.isRoomsCall;
    }

    /**
     * Set the isRoomsCall property: Is the calling event a room call.
     * 
     * @param isRoomsCall the isRoomsCall value to set.
     * @return the AcsCallingEventProperties object itself.
     */
    public AcsCallingEventProperties setIsRoomsCall(Boolean isRoomsCall) {
        this.isRoomsCall = isRoomsCall;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("startedBy", this.startedBy);
        jsonWriter.writeStringField("serverCallId", this.serverCallId);
        jsonWriter.writeStringField("correlationId", this.correlationId);
        jsonWriter.writeJsonField("group", this.group);
        jsonWriter.writeJsonField("room", this.room);
        jsonWriter.writeBooleanField("isTwoParty", this.isTwoParty);
        jsonWriter.writeBooleanField("isRoomsCall", this.isRoomsCall);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsCallingEventProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsCallingEventProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsCallingEventProperties.
     */
    public static AcsCallingEventProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsCallingEventProperties deserializedAcsCallingEventProperties = new AcsCallingEventProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("startedBy".equals(fieldName)) {
                    deserializedAcsCallingEventProperties.startedBy = AcsCallParticipantProperties.fromJson(reader);
                } else if ("serverCallId".equals(fieldName)) {
                    deserializedAcsCallingEventProperties.serverCallId = reader.getString();
                } else if ("correlationId".equals(fieldName)) {
                    deserializedAcsCallingEventProperties.correlationId = reader.getString();
                } else if ("group".equals(fieldName)) {
                    deserializedAcsCallingEventProperties.group = AcsCallGroupProperties.fromJson(reader);
                } else if ("room".equals(fieldName)) {
                    deserializedAcsCallingEventProperties.room = AcsCallRoomProperties.fromJson(reader);
                } else if ("isTwoParty".equals(fieldName)) {
                    deserializedAcsCallingEventProperties.isTwoParty = reader.getNullable(JsonReader::getBoolean);
                } else if ("isRoomsCall".equals(fieldName)) {
                    deserializedAcsCallingEventProperties.isRoomsCall = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsCallingEventProperties;
        });
    }
}
