// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatAzureBotCommandReceivedInThread
 * event.
 */
@Fluent
public final class AcsChatAzureBotCommandReceivedInThreadEventData extends AcsChatMessageEventInThreadBaseProperties {
    /*
     * The body of the chat message
     */
    private String messageBody;

    /*
     * The chat message metadata
     */
    private Map<String, String> metadata;

    /**
     * Creates an instance of AcsChatAzureBotCommandReceivedInThreadEventData class.
     */
    public AcsChatAzureBotCommandReceivedInThreadEventData() {
    }

    /**
     * Get the messageBody property: The body of the chat message.
     * 
     * @return the messageBody value.
     */
    public String getMessageBody() {
        return this.messageBody;
    }

    /**
     * Set the messageBody property: The body of the chat message.
     * 
     * @param messageBody the messageBody value to set.
     * @return the AcsChatAzureBotCommandReceivedInThreadEventData object itself.
     */
    public AcsChatAzureBotCommandReceivedInThreadEventData setMessageBody(String messageBody) {
        this.messageBody = messageBody;
        return this;
    }

    /**
     * Get the metadata property: The chat message metadata.
     * 
     * @return the metadata value.
     */
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: The chat message metadata.
     * 
     * @param metadata the metadata value to set.
     * @return the AcsChatAzureBotCommandReceivedInThreadEventData object itself.
     */
    public AcsChatAzureBotCommandReceivedInThreadEventData setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData setMessageId(String messageId) {
        super.setMessageId(messageId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData
        setSenderCommunicationIdentifier(CommunicationIdentifierModel senderCommunicationIdentifier) {
        super.setSenderCommunicationIdentifier(senderCommunicationIdentifier);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData setSenderDisplayName(String senderDisplayName) {
        super.setSenderDisplayName(senderDisplayName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData setComposeTime(OffsetDateTime composeTime) {
        super.setComposeTime(composeTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData setType(String type) {
        super.setType(type);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", getTransactionId());
        jsonWriter.writeStringField("threadId", getThreadId());
        jsonWriter.writeStringField("messageId", getMessageId());
        jsonWriter.writeJsonField("senderCommunicationIdentifier", getSenderCommunicationIdentifier());
        jsonWriter.writeStringField("type", getType());
        jsonWriter.writeStringField("senderDisplayName", getSenderDisplayName());
        jsonWriter.writeStringField("composeTime",
            getComposeTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getComposeTime()));
        jsonWriter.writeNumberField("version", getVersion());
        jsonWriter.writeStringField("messageBody", this.messageBody);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsChatAzureBotCommandReceivedInThreadEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsChatAzureBotCommandReceivedInThreadEventData if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsChatAzureBotCommandReceivedInThreadEventData.
     */
    public static AcsChatAzureBotCommandReceivedInThreadEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsChatAzureBotCommandReceivedInThreadEventData deserializedAcsChatAzureBotCommandReceivedInThreadEventData
                = new AcsChatAzureBotCommandReceivedInThreadEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.setTransactionId(reader.getString());
                } else if ("threadId".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.setThreadId(reader.getString());
                } else if ("messageId".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.setMessageId(reader.getString());
                } else if ("senderCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData
                        .setSenderCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                } else if ("type".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.setType(reader.getString());
                } else if ("senderDisplayName".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData
                        .setSenderDisplayName(reader.getString());
                } else if ("composeTime".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.setComposeTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("version".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData
                        .setVersion(reader.getNullable(JsonReader::getLong));
                } else if ("messageBody".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.messageBody = reader.getString();
                } else if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.metadata = metadata;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsChatAzureBotCommandReceivedInThreadEventData;
        });
    }
}
