// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatMessageEdited event.
 */
@Fluent
public final class AcsChatMessageEditedEventData extends AcsChatMessageEventBaseProperties {
    /*
     * The body of the chat message
     */
    private String messageBody;

    /*
     * The chat message metadata
     */
    private Map<String, String> metadata;

    /*
     * The time at which the message was edited
     */
    private OffsetDateTime editTime;

    /**
     * Creates an instance of AcsChatMessageEditedEventData class.
     */
    public AcsChatMessageEditedEventData() {
    }

    /**
     * Get the messageBody property: The body of the chat message.
     * 
     * @return the messageBody value.
     */
    public String getMessageBody() {
        return this.messageBody;
    }

    /**
     * Set the messageBody property: The body of the chat message.
     * 
     * @param messageBody the messageBody value to set.
     * @return the AcsChatMessageEditedEventData object itself.
     */
    public AcsChatMessageEditedEventData setMessageBody(String messageBody) {
        this.messageBody = messageBody;
        return this;
    }

    /**
     * Get the metadata property: The chat message metadata.
     * 
     * @return the metadata value.
     */
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: The chat message metadata.
     * 
     * @param metadata the metadata value to set.
     * @return the AcsChatMessageEditedEventData object itself.
     */
    public AcsChatMessageEditedEventData setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the editTime property: The time at which the message was edited.
     * 
     * @return the editTime value.
     */
    public OffsetDateTime getEditTime() {
        return this.editTime;
    }

    /**
     * Set the editTime property: The time at which the message was edited.
     * 
     * @param editTime the editTime value to set.
     * @return the AcsChatMessageEditedEventData object itself.
     */
    public AcsChatMessageEditedEventData setEditTime(OffsetDateTime editTime) {
        this.editTime = editTime;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageEditedEventData setMessageId(String messageId) {
        super.setMessageId(messageId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageEditedEventData
        setSenderCommunicationIdentifier(CommunicationIdentifierModel senderCommunicationIdentifier) {
        super.setSenderCommunicationIdentifier(senderCommunicationIdentifier);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageEditedEventData setSenderDisplayName(String senderDisplayName) {
        super.setSenderDisplayName(senderDisplayName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageEditedEventData setComposeTime(OffsetDateTime composeTime) {
        super.setComposeTime(composeTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageEditedEventData setType(String type) {
        super.setType(type);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageEditedEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageEditedEventData
        setRecipientCommunicationIdentifier(CommunicationIdentifierModel recipientCommunicationIdentifier) {
        super.setRecipientCommunicationIdentifier(recipientCommunicationIdentifier);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageEditedEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageEditedEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("messageId", getMessageId());
        jsonWriter.writeJsonField("senderCommunicationIdentifier", getSenderCommunicationIdentifier());
        jsonWriter.writeStringField("type", getType());
        jsonWriter.writeJsonField("recipientCommunicationIdentifier", getRecipientCommunicationIdentifier());
        jsonWriter.writeStringField("transactionId", getTransactionId());
        jsonWriter.writeStringField("threadId", getThreadId());
        jsonWriter.writeStringField("senderDisplayName", getSenderDisplayName());
        jsonWriter.writeStringField("composeTime",
            getComposeTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getComposeTime()));
        jsonWriter.writeNumberField("version", getVersion());
        jsonWriter.writeStringField("messageBody", this.messageBody);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("editTime",
            this.editTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.editTime));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsChatMessageEditedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsChatMessageEditedEventData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsChatMessageEditedEventData.
     */
    public static AcsChatMessageEditedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsChatMessageEditedEventData deserializedAcsChatMessageEditedEventData
                = new AcsChatMessageEditedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("messageId".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setMessageId(reader.getString());
                } else if ("senderCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData
                        .setSenderCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                } else if ("type".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setType(reader.getString());
                } else if ("recipientCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData
                        .setRecipientCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                } else if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setTransactionId(reader.getString());
                } else if ("threadId".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setThreadId(reader.getString());
                } else if ("senderDisplayName".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setSenderDisplayName(reader.getString());
                } else if ("composeTime".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setComposeTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("version".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.setVersion(reader.getNullable(JsonReader::getLong));
                } else if ("messageBody".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.messageBody = reader.getString();
                } else if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsChatMessageEditedEventData.metadata = metadata;
                } else if ("editTime".equals(fieldName)) {
                    deserializedAcsChatMessageEditedEventData.editTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsChatMessageEditedEventData;
        });
    }
}
