// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatMessageReceived event.
 */
@Fluent
public final class AcsChatMessageReceivedEventData extends AcsChatMessageEventBaseProperties {
    /*
     * The body of the chat message
     */
    private String messageBody;

    /*
     * The chat message metadata
     */
    private Map<String, String> metadata;

    /**
     * Creates an instance of AcsChatMessageReceivedEventData class.
     */
    public AcsChatMessageReceivedEventData() {
    }

    /**
     * Get the messageBody property: The body of the chat message.
     * 
     * @return the messageBody value.
     */
    public String getMessageBody() {
        return this.messageBody;
    }

    /**
     * Set the messageBody property: The body of the chat message.
     * 
     * @param messageBody the messageBody value to set.
     * @return the AcsChatMessageReceivedEventData object itself.
     */
    public AcsChatMessageReceivedEventData setMessageBody(String messageBody) {
        this.messageBody = messageBody;
        return this;
    }

    /**
     * Get the metadata property: The chat message metadata.
     * 
     * @return the metadata value.
     */
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: The chat message metadata.
     * 
     * @param metadata the metadata value to set.
     * @return the AcsChatMessageReceivedEventData object itself.
     */
    public AcsChatMessageReceivedEventData setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageReceivedEventData setMessageId(String messageId) {
        super.setMessageId(messageId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageReceivedEventData
        setSenderCommunicationIdentifier(CommunicationIdentifierModel senderCommunicationIdentifier) {
        super.setSenderCommunicationIdentifier(senderCommunicationIdentifier);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageReceivedEventData setSenderDisplayName(String senderDisplayName) {
        super.setSenderDisplayName(senderDisplayName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageReceivedEventData setComposeTime(OffsetDateTime composeTime) {
        super.setComposeTime(composeTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageReceivedEventData setType(String type) {
        super.setType(type);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageReceivedEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageReceivedEventData
        setRecipientCommunicationIdentifier(CommunicationIdentifierModel recipientCommunicationIdentifier) {
        super.setRecipientCommunicationIdentifier(recipientCommunicationIdentifier);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageReceivedEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatMessageReceivedEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("messageId", getMessageId());
        jsonWriter.writeJsonField("senderCommunicationIdentifier", getSenderCommunicationIdentifier());
        jsonWriter.writeStringField("type", getType());
        jsonWriter.writeJsonField("recipientCommunicationIdentifier", getRecipientCommunicationIdentifier());
        jsonWriter.writeStringField("transactionId", getTransactionId());
        jsonWriter.writeStringField("threadId", getThreadId());
        jsonWriter.writeStringField("senderDisplayName", getSenderDisplayName());
        jsonWriter.writeStringField("composeTime",
            getComposeTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getComposeTime()));
        jsonWriter.writeNumberField("version", getVersion());
        jsonWriter.writeStringField("messageBody", this.messageBody);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsChatMessageReceivedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsChatMessageReceivedEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsChatMessageReceivedEventData.
     */
    public static AcsChatMessageReceivedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsChatMessageReceivedEventData deserializedAcsChatMessageReceivedEventData
                = new AcsChatMessageReceivedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("messageId".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setMessageId(reader.getString());
                } else if ("senderCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData
                        .setSenderCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                } else if ("type".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setType(reader.getString());
                } else if ("recipientCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData
                        .setRecipientCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                } else if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setTransactionId(reader.getString());
                } else if ("threadId".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setThreadId(reader.getString());
                } else if ("senderDisplayName".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setSenderDisplayName(reader.getString());
                } else if ("composeTime".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setComposeTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("version".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setVersion(reader.getNullable(JsonReader::getLong));
                } else if ("messageBody".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.messageBody = reader.getString();
                } else if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsChatMessageReceivedEventData.metadata = metadata;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsChatMessageReceivedEventData;
        });
    }
}
