// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatThreadParticipantRemoved event.
 */
@Fluent
public final class AcsChatParticipantRemovedFromThreadEventData extends AcsChatEventInThreadBaseProperties {
    /*
     * The time at which the user was removed to the thread
     */
    private OffsetDateTime time;

    /*
     * The communication identifier of the user who removed the user
     */
    private CommunicationIdentifierModel removedByCommunicationIdentifier;

    /*
     * The details of the user who was removed
     */
    private AcsChatThreadParticipantProperties participantRemoved;

    /*
     * The version of the thread
     */
    private Long version;

    /**
     * Creates an instance of AcsChatParticipantRemovedFromThreadEventData class.
     */
    public AcsChatParticipantRemovedFromThreadEventData() {
    }

    /**
     * Get the time property: The time at which the user was removed to the thread.
     * 
     * @return the time value.
     */
    public OffsetDateTime getTime() {
        return this.time;
    }

    /**
     * Set the time property: The time at which the user was removed to the thread.
     * 
     * @param time the time value to set.
     * @return the AcsChatParticipantRemovedFromThreadEventData object itself.
     */
    public AcsChatParticipantRemovedFromThreadEventData setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    /**
     * Get the removedByCommunicationIdentifier property: The communication identifier of the user who removed the user.
     * 
     * @return the removedByCommunicationIdentifier value.
     */
    public CommunicationIdentifierModel getRemovedByCommunicationIdentifier() {
        return this.removedByCommunicationIdentifier;
    }

    /**
     * Set the removedByCommunicationIdentifier property: The communication identifier of the user who removed the user.
     * 
     * @param removedByCommunicationIdentifier the removedByCommunicationIdentifier value to set.
     * @return the AcsChatParticipantRemovedFromThreadEventData object itself.
     */
    public AcsChatParticipantRemovedFromThreadEventData
        setRemovedByCommunicationIdentifier(CommunicationIdentifierModel removedByCommunicationIdentifier) {
        this.removedByCommunicationIdentifier = removedByCommunicationIdentifier;
        return this;
    }

    /**
     * Get the participantRemoved property: The details of the user who was removed.
     * 
     * @return the participantRemoved value.
     */
    public AcsChatThreadParticipantProperties getParticipantRemoved() {
        return this.participantRemoved;
    }

    /**
     * Set the participantRemoved property: The details of the user who was removed.
     * 
     * @param participantRemoved the participantRemoved value to set.
     * @return the AcsChatParticipantRemovedFromThreadEventData object itself.
     */
    public AcsChatParticipantRemovedFromThreadEventData
        setParticipantRemoved(AcsChatThreadParticipantProperties participantRemoved) {
        this.participantRemoved = participantRemoved;
        return this;
    }

    /**
     * Get the version property: The version of the thread.
     * 
     * @return the version value.
     */
    public Long getVersion() {
        return this.version;
    }

    /**
     * Set the version property: The version of the thread.
     * 
     * @param version the version value to set.
     * @return the AcsChatParticipantRemovedFromThreadEventData object itself.
     */
    public AcsChatParticipantRemovedFromThreadEventData setVersion(Long version) {
        this.version = version;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatParticipantRemovedFromThreadEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatParticipantRemovedFromThreadEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", getTransactionId());
        jsonWriter.writeStringField("threadId", getThreadId());
        jsonWriter.writeJsonField("removedByCommunicationIdentifier", this.removedByCommunicationIdentifier);
        jsonWriter.writeJsonField("participantRemoved", this.participantRemoved);
        jsonWriter.writeStringField("time",
            this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        jsonWriter.writeNumberField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsChatParticipantRemovedFromThreadEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsChatParticipantRemovedFromThreadEventData if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsChatParticipantRemovedFromThreadEventData.
     */
    public static AcsChatParticipantRemovedFromThreadEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsChatParticipantRemovedFromThreadEventData deserializedAcsChatParticipantRemovedFromThreadEventData
                = new AcsChatParticipantRemovedFromThreadEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadEventData.setTransactionId(reader.getString());
                } else if ("threadId".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadEventData.setThreadId(reader.getString());
                } else if ("removedByCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadEventData.removedByCommunicationIdentifier
                        = CommunicationIdentifierModel.fromJson(reader);
                } else if ("participantRemoved".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadEventData.participantRemoved
                        = AcsChatThreadParticipantProperties.fromJson(reader);
                } else if ("time".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadEventData.time = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("version".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadEventData.version
                        = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsChatParticipantRemovedFromThreadEventData;
        });
    }
}
