// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of common properties of all chat thread events.
 */
@Fluent
public class AcsChatThreadEventInThreadBaseProperties extends AcsChatEventInThreadBaseProperties {
    /*
     * The original creation time of the thread
     */
    private OffsetDateTime createTime;

    /*
     * The version of the thread
     */
    private Long version;

    /**
     * Creates an instance of AcsChatThreadEventInThreadBaseProperties class.
     */
    public AcsChatThreadEventInThreadBaseProperties() {
    }

    /**
     * Get the createTime property: The original creation time of the thread.
     * 
     * @return the createTime value.
     */
    public OffsetDateTime getCreateTime() {
        return this.createTime;
    }

    /**
     * Set the createTime property: The original creation time of the thread.
     * 
     * @param createTime the createTime value to set.
     * @return the AcsChatThreadEventInThreadBaseProperties object itself.
     */
    public AcsChatThreadEventInThreadBaseProperties setCreateTime(OffsetDateTime createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * Get the version property: The version of the thread.
     * 
     * @return the version value.
     */
    public Long getVersion() {
        return this.version;
    }

    /**
     * Set the version property: The version of the thread.
     * 
     * @param version the version value to set.
     * @return the AcsChatThreadEventInThreadBaseProperties object itself.
     */
    public AcsChatThreadEventInThreadBaseProperties setVersion(Long version) {
        this.version = version;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatThreadEventInThreadBaseProperties setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatThreadEventInThreadBaseProperties setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", getTransactionId());
        jsonWriter.writeStringField("threadId", getThreadId());
        jsonWriter.writeStringField("createTime",
            this.createTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createTime));
        jsonWriter.writeNumberField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsChatThreadEventInThreadBaseProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsChatThreadEventInThreadBaseProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsChatThreadEventInThreadBaseProperties.
     */
    public static AcsChatThreadEventInThreadBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsChatThreadEventInThreadBaseProperties deserializedAcsChatThreadEventInThreadBaseProperties
                = new AcsChatThreadEventInThreadBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatThreadEventInThreadBaseProperties.setTransactionId(reader.getString());
                } else if ("threadId".equals(fieldName)) {
                    deserializedAcsChatThreadEventInThreadBaseProperties.setThreadId(reader.getString());
                } else if ("createTime".equals(fieldName)) {
                    deserializedAcsChatThreadEventInThreadBaseProperties.createTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("version".equals(fieldName)) {
                    deserializedAcsChatThreadEventInThreadBaseProperties.version
                        = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsChatThreadEventInThreadBaseProperties;
        });
    }
}
