// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.models.ResponseError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.implementation.models.AcsMessageChannelEventError;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.AdvancedMessageDeliveryStatusUpdated
 * event.
 */
@Fluent
public final class AcsMessageDeliveryStatusUpdatedEventData extends AcsMessageEventData {

    /*
     * The message id
     */
    private String messageId;

    /*
     * The updated message status
     */
    private AcsMessageDeliveryStatus status;

    /*
     * The updated message channel type
     */
    private AcsMessageChannelKind channelKind;

    /**
     * Creates an instance of AcsMessageDeliveryStatusUpdatedEventData class.
     */
    public AcsMessageDeliveryStatusUpdatedEventData() {
    }

    /**
     * Get the messageId property: The message id.
     *
     * @return the messageId value.
     */
    public String getMessageId() {
        return this.messageId;
    }

    /**
     * Set the messageId property: The message id.
     *
     * @param messageId the messageId value to set.
     * @return the AcsMessageDeliveryStatusUpdatedEventData object itself.
     */
    public AcsMessageDeliveryStatusUpdatedEventData setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    /**
     * Get the status property: The updated message status.
     *
     * @return the status value.
     */
    public AcsMessageDeliveryStatus getStatus() {
        return this.status;
    }

    /**
     * Set the status property: The updated message status.
     *
     * @param status the status value to set.
     * @return the AcsMessageDeliveryStatusUpdatedEventData object itself.
     */
    public AcsMessageDeliveryStatusUpdatedEventData setStatus(AcsMessageDeliveryStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the channelKind property: The updated message channel type.
     *
     * @return the channelKind value.
     */
    public AcsMessageChannelKind getChannelKind() {
        return this.channelKind;
    }

    /**
     * Set the channelKind property: The updated message channel type.
     *
     * @param channelKind the channelKind value to set.
     * @return the AcsMessageDeliveryStatusUpdatedEventData object itself.
     */
    public AcsMessageDeliveryStatusUpdatedEventData setChannelKind(AcsMessageChannelKind channelKind) {
        this.channelKind = channelKind;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsMessageDeliveryStatusUpdatedEventData setFrom(String from) {
        super.setFrom(from);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsMessageDeliveryStatusUpdatedEventData setTo(String to) {
        super.setTo(to);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsMessageDeliveryStatusUpdatedEventData setReceivedTimestamp(OffsetDateTime receivedTimestamp) {
        super.setReceivedTimestamp(receivedTimestamp);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("from", getFrom());
        jsonWriter.writeStringField("to", getTo());
        jsonWriter.writeStringField("receivedTimestamp",
            getReceivedTimestamp() == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getReceivedTimestamp()));
        jsonWriter.writeJsonField("error", getError());
        jsonWriter.writeStringField("messageId", this.messageId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("channelType", this.channelKind == null ? null : this.channelKind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsMessageDeliveryStatusUpdatedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsMessageDeliveryStatusUpdatedEventData if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsMessageDeliveryStatusUpdatedEventData.
     */
    public static AcsMessageDeliveryStatusUpdatedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsMessageDeliveryStatusUpdatedEventData deserializedAcsMessageDeliveryStatusUpdatedEventData
                = new AcsMessageDeliveryStatusUpdatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("from".equals(fieldName)) {
                    deserializedAcsMessageDeliveryStatusUpdatedEventData.setFrom(reader.getString());
                } else if ("to".equals(fieldName)) {
                    deserializedAcsMessageDeliveryStatusUpdatedEventData.setTo(reader.getString());
                } else if ("receivedTimestamp".equals(fieldName)) {
                    deserializedAcsMessageDeliveryStatusUpdatedEventData.setReceivedTimestamp(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("error".equals(fieldName)) {
                    deserializedAcsMessageDeliveryStatusUpdatedEventData
                        .setError(AcsMessageChannelEventError.fromJson(reader));
                } else if ("messageId".equals(fieldName)) {
                    deserializedAcsMessageDeliveryStatusUpdatedEventData.messageId = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedAcsMessageDeliveryStatusUpdatedEventData.status
                        = AcsMessageDeliveryStatus.fromString(reader.getString());
                } else if ("channelType".equals(fieldName)) {
                    deserializedAcsMessageDeliveryStatusUpdatedEventData.channelKind
                        = AcsMessageChannelKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsMessageDeliveryStatusUpdatedEventData;
        });
    }

    /**
     * Set the error property: The channel error code and message.
     *
     * @param error The ResponseError object containing error code and message.
     * @return the AcsMessageDeliveryStatusUpdatedEventData object itself.
     */
    public AcsMessageDeliveryStatusUpdatedEventData setError(ResponseError error) {
        super.setError(error);
        return this;
    }
}
