// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.models.ResponseError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.implementation.models.AcsMessageChannelEventError;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of common properties of all chat thread events.
 */
@Fluent
public class AcsMessageEventData implements JsonSerializable<AcsMessageEventData> {

    /*
     * The message sender
     */
    private String from;

    /*
     * The message recipient
     */
    private String to;

    /*
     * The time message was received
     */
    private OffsetDateTime receivedTimestamp;

    /*
     * The channel event error
     */
    private AcsMessageChannelEventError error;

    /**
     * Creates an instance of AcsMessageEventData class.
     */
    public AcsMessageEventData() {
    }

    /**
     * Get the from property: The message sender.
     *
     * @return the from value.
     */
    public String getFrom() {
        return this.from;
    }

    /**
     * Set the from property: The message sender.
     *
     * @param from the from value to set.
     * @return the AcsMessageEventData object itself.
     */
    public AcsMessageEventData setFrom(String from) {
        this.from = from;
        return this;
    }

    /**
     * Get the to property: The message recipient.
     *
     * @return the to value.
     */
    public String getTo() {
        return this.to;
    }

    /**
     * Set the to property: The message recipient.
     *
     * @param to the to value to set.
     * @return the AcsMessageEventData object itself.
     */
    public AcsMessageEventData setTo(String to) {
        this.to = to;
        return this;
    }

    /**
     * Get the receivedTimestamp property: The time message was received.
     *
     * @return the receivedTimestamp value.
     */
    public OffsetDateTime getReceivedTimestamp() {
        return this.receivedTimestamp;
    }

    /**
     * Set the receivedTimestamp property: The time message was received.
     *
     * @param receivedTimestamp the receivedTimestamp value to set.
     * @return the AcsMessageEventData object itself.
     */
    public AcsMessageEventData setReceivedTimestamp(OffsetDateTime receivedTimestamp) {
        this.receivedTimestamp = receivedTimestamp;
        return this;
    }

    /**
     * Get the error property: The channel error code and message.
     *
     * @return the error value.
     */
    public ResponseError getError() {
        return new ResponseError(this.error.getChannelCode(), this.error.getChannelMessage());
    }

    /**
     * Used for json deserialization in derived types.
     *
     * @param error The error value to set
     */
    void setError(AcsMessageChannelEventError error) {
        this.error = error;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("from", this.from);
        jsonWriter.writeStringField("to", this.to);
        jsonWriter.writeStringField("receivedTimestamp",
            this.receivedTimestamp == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.receivedTimestamp));
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsMessageEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsMessageEventData if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsMessageEventData.
     */
    public static AcsMessageEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsMessageEventData deserializedAcsMessageEventData = new AcsMessageEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("from".equals(fieldName)) {
                    deserializedAcsMessageEventData.from = reader.getString();
                } else if ("to".equals(fieldName)) {
                    deserializedAcsMessageEventData.to = reader.getString();
                } else if ("receivedTimestamp".equals(fieldName)) {
                    deserializedAcsMessageEventData.receivedTimestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("error".equals(fieldName)) {
                    deserializedAcsMessageEventData.error = AcsMessageChannelEventError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsMessageEventData;
        });
    }

    /**
     * Set the error property: The channel error code and message.
     *
     * @param error The ResponseError object containing error code and message.
     * @return the AcsMessageEventData object itself.
     */
    public AcsMessageEventData setError(ResponseError error) {
        this.error
            = new AcsMessageChannelEventError().setChannelCode(error.getCode()).setChannelMessage(error.getMessage());
        return this;
    }
}
