// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Message Reaction Content.
 */
@Fluent
public final class AcsMessageReactionContent implements JsonSerializable<AcsMessageReactionContent> {
    /*
     * WhatsApp message ID of message you want to apply the emoji to.
     */
    private String messageId;

    /*
     * Unicode escape sequence of the emoji.
     */
    private String emoji;

    /**
     * Creates an instance of AcsMessageReactionContent class.
     */
    public AcsMessageReactionContent() {
    }

    /**
     * Get the messageId property: WhatsApp message ID of message you want to apply the emoji to.
     * 
     * @return the messageId value.
     */
    public String getMessageId() {
        return this.messageId;
    }

    /**
     * Set the messageId property: WhatsApp message ID of message you want to apply the emoji to.
     * 
     * @param messageId the messageId value to set.
     * @return the AcsMessageReactionContent object itself.
     */
    public AcsMessageReactionContent setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    /**
     * Get the emoji property: Unicode escape sequence of the emoji.
     * 
     * @return the emoji value.
     */
    public String getEmoji() {
        return this.emoji;
    }

    /**
     * Set the emoji property: Unicode escape sequence of the emoji.
     * 
     * @param emoji the emoji value to set.
     * @return the AcsMessageReactionContent object itself.
     */
    public AcsMessageReactionContent setEmoji(String emoji) {
        this.emoji = emoji;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("messageId", this.messageId);
        jsonWriter.writeStringField("emoji", this.emoji);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsMessageReactionContent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsMessageReactionContent if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsMessageReactionContent.
     */
    public static AcsMessageReactionContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsMessageReactionContent deserializedAcsMessageReactionContent = new AcsMessageReactionContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("messageId".equals(fieldName)) {
                    deserializedAcsMessageReactionContent.messageId = reader.getString();
                } else if ("emoji".equals(fieldName)) {
                    deserializedAcsMessageReactionContent.emoji = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsMessageReactionContent;
        });
    }
}
