// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.models.ResponseError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.implementation.models.AcsMessageChannelEventError;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.AdvancedMessageReceived event.
 */
@Fluent
public final class AcsMessageReceivedEventData extends AcsMessageEventData {

    /*
     * The received message content
     */
    private String content;

    /*
     * Message ID. Format is Guid as string.
     */
    private String messageId;

    /*
     * The received message channel Kind
     */
    private AcsMessageChannelKind channelKind;

    /*
     * WhatsApp Message Type
     */
    private String messageType;

    /*
     * The received message media content
     */
    private AcsMessageMediaContent mediaContent;

    /*
     * The received message reaction content
     */
    private AcsMessageReactionContent reaction;

    /*
     * The received message context
     */
    private AcsMessageContext context;

    /*
     * The received message button content
     */
    private AcsMessageButtonContent button;

    /*
     * The received message interactive content
     */
    private AcsMessageInteractiveContent interactiveContent;

    /**
     * Creates an instance of AcsMessageReceivedEventData class.
     */
    public AcsMessageReceivedEventData() {
    }

    /**
     * Get the content property: The received message content.
     *
     * @return the content value.
     */
    public String getContent() {
        return this.content;
    }

    /**
     * Set the content property: The received message content.
     *
     * @param content the content value to set.
     * @return the AcsMessageReceivedEventData object itself.
     */
    public AcsMessageReceivedEventData setContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Get the messageId property: Message ID. Format is Guid as string.
     *
     * @return the messageId value.
     */
    public String getMessageId() {
        return this.messageId;
    }

    /**
     * Set the messageId property: Message ID. Format is Guid as string.
     *
     * @param messageId the messageId value to set.
     * @return the AcsMessageReceivedEventData object itself.
     */
    public AcsMessageReceivedEventData setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    /**
     * Get the channelKind property: The received message channel Kind.
     *
     * @return the channelKind value.
     */
    public AcsMessageChannelKind getChannelKind() {
        return this.channelKind;
    }

    /**
     * Set the channelKind property: The received message channel Kind.
     *
     * @param channelKind the channelKind value to set.
     * @return the AcsMessageReceivedEventData object itself.
     */
    public AcsMessageReceivedEventData setChannelKind(AcsMessageChannelKind channelKind) {
        this.channelKind = channelKind;
        return this;
    }

    /**
     * Get the messageType property: WhatsApp Message Type.
     *
     * @return the messageType value.
     */
    public String getMessageType() {
        return this.messageType;
    }

    /**
     * Set the messageType property: WhatsApp Message Type.
     *
     * @param messageType the messageType value to set.
     * @return the AcsMessageReceivedEventData object itself.
     */
    public AcsMessageReceivedEventData setMessageType(String messageType) {
        this.messageType = messageType;
        return this;
    }

    /**
     * Get the mediaContent property: The received message media content.
     *
     * @return the mediaContent value.
     */
    public AcsMessageMediaContent getMediaContent() {
        return this.mediaContent;
    }

    /**
     * Set the mediaContent property: The received message media content.
     *
     * @param mediaContent the mediaContent value to set.
     * @return the AcsMessageReceivedEventData object itself.
     */
    public AcsMessageReceivedEventData setMediaContent(AcsMessageMediaContent mediaContent) {
        this.mediaContent = mediaContent;
        return this;
    }

    /**
     * Get the reaction property: The received message reaction content.
     *
     * @return the reaction value.
     */
    public AcsMessageReactionContent getReaction() {
        return this.reaction;
    }

    /**
     * Set the reaction property: The received message reaction content.
     *
     * @param reaction the reaction value to set.
     * @return the AcsMessageReceivedEventData object itself.
     */
    public AcsMessageReceivedEventData setReaction(AcsMessageReactionContent reaction) {
        this.reaction = reaction;
        return this;
    }

    /**
     * Get the context property: The received message context.
     *
     * @return the context value.
     */
    public AcsMessageContext getContext() {
        return this.context;
    }

    /**
     * Set the context property: The received message context.
     *
     * @param context the context value to set.
     * @return the AcsMessageReceivedEventData object itself.
     */
    public AcsMessageReceivedEventData setContext(AcsMessageContext context) {
        this.context = context;
        return this;
    }

    /**
     * Get the button property: The received message button content.
     *
     * @return the button value.
     */
    public AcsMessageButtonContent getButton() {
        return this.button;
    }

    /**
     * Set the button property: The received message button content.
     *
     * @param button the button value to set.
     * @return the AcsMessageReceivedEventData object itself.
     */
    public AcsMessageReceivedEventData setButton(AcsMessageButtonContent button) {
        this.button = button;
        return this;
    }

    /**
     * Get the interactiveContent property: The received message interactive content.
     *
     * @return the interactiveContent value.
     */
    public AcsMessageInteractiveContent getInteractiveContent() {
        return this.interactiveContent;
    }

    /**
     * Set the interactiveContent property: The received message interactive content.
     *
     * @param interactiveContent the interactiveContent value to set.
     * @return the AcsMessageReceivedEventData object itself.
     */
    public AcsMessageReceivedEventData setInteractiveContent(AcsMessageInteractiveContent interactiveContent) {
        this.interactiveContent = interactiveContent;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsMessageReceivedEventData setFrom(String from) {
        super.setFrom(from);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsMessageReceivedEventData setTo(String to) {
        super.setTo(to);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsMessageReceivedEventData setReceivedTimestamp(OffsetDateTime receivedTimestamp) {
        super.setReceivedTimestamp(receivedTimestamp);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("from", getFrom());
        jsonWriter.writeStringField("to", getTo());
        jsonWriter.writeStringField("receivedTimestamp",
            getReceivedTimestamp() == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getReceivedTimestamp()));
        jsonWriter.writeJsonField("error", getError());
        jsonWriter.writeStringField("messageType", this.messageType);
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("messageId", this.messageId);
        jsonWriter.writeStringField("channelType", this.channelKind == null ? null : this.channelKind.toString());
        jsonWriter.writeJsonField("media", this.mediaContent);
        jsonWriter.writeJsonField("reaction", this.reaction);
        jsonWriter.writeJsonField("context", this.context);
        jsonWriter.writeJsonField("button", this.button);
        jsonWriter.writeJsonField("interactive", this.interactiveContent);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsMessageReceivedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsMessageReceivedEventData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsMessageReceivedEventData.
     */
    public static AcsMessageReceivedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsMessageReceivedEventData deserializedAcsMessageReceivedEventData = new AcsMessageReceivedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("from".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.setFrom(reader.getString());
                } else if ("to".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.setTo(reader.getString());
                } else if ("receivedTimestamp".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.setReceivedTimestamp(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("error".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.setError(AcsMessageChannelEventError.fromJson(reader));
                } else if ("messageType".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.messageType = reader.getString();
                } else if ("content".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.content = reader.getString();
                } else if ("messageId".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.messageId = reader.getString();
                } else if ("channelType".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.channelKind
                        = AcsMessageChannelKind.fromString(reader.getString());
                } else if ("media".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.mediaContent = AcsMessageMediaContent.fromJson(reader);
                } else if ("reaction".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.reaction = AcsMessageReactionContent.fromJson(reader);
                } else if ("context".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.context = AcsMessageContext.fromJson(reader);
                } else if ("button".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.button = AcsMessageButtonContent.fromJson(reader);
                } else if ("interactive".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.interactiveContent
                        = AcsMessageInteractiveContent.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsMessageReceivedEventData;
        });
    }

    /**
     * Set the error property: The channel error code and message.
     *
     * @param error The ResponseError object containing error code and message.
     * @return the AcsMessageReceivedEventData object itself.
     */
    public AcsMessageReceivedEventData setError(ResponseError error) {
        super.setError(error);
        return this;
    }
}
