// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterJobClassified event.
 */
@Fluent
public final class AcsRouterJobClassifiedEventData extends AcsRouterJobEventData {
    /*
     * Router Job Queue Info
     */
    private AcsRouterQueueDetails queueDetails;

    /*
     * Router Job Classification Policy Id
     */
    private String classificationPolicyId;

    /*
     * Router Job Priority
     */
    private Integer priority;

    /*
     * Router Job Attached Worker Selector
     */
    private List<AcsRouterWorkerSelector> attachedWorkerSelectors;

    /**
     * Creates an instance of AcsRouterJobClassifiedEventData class.
     */
    public AcsRouterJobClassifiedEventData() {
    }

    /**
     * Get the queueDetails property: Router Job Queue Info.
     * 
     * @return the queueDetails value.
     */
    public AcsRouterQueueDetails getQueueDetails() {
        return this.queueDetails;
    }

    /**
     * Set the queueDetails property: Router Job Queue Info.
     * 
     * @param queueDetails the queueDetails value to set.
     * @return the AcsRouterJobClassifiedEventData object itself.
     */
    public AcsRouterJobClassifiedEventData setQueueDetails(AcsRouterQueueDetails queueDetails) {
        this.queueDetails = queueDetails;
        return this;
    }

    /**
     * Get the classificationPolicyId property: Router Job Classification Policy Id.
     * 
     * @return the classificationPolicyId value.
     */
    public String getClassificationPolicyId() {
        return this.classificationPolicyId;
    }

    /**
     * Set the classificationPolicyId property: Router Job Classification Policy Id.
     * 
     * @param classificationPolicyId the classificationPolicyId value to set.
     * @return the AcsRouterJobClassifiedEventData object itself.
     */
    public AcsRouterJobClassifiedEventData setClassificationPolicyId(String classificationPolicyId) {
        this.classificationPolicyId = classificationPolicyId;
        return this;
    }

    /**
     * Get the priority property: Router Job Priority.
     * 
     * @return the priority value.
     */
    public Integer getPriority() {
        return this.priority;
    }

    /**
     * Set the priority property: Router Job Priority.
     * 
     * @param priority the priority value to set.
     * @return the AcsRouterJobClassifiedEventData object itself.
     */
    public AcsRouterJobClassifiedEventData setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the attachedWorkerSelectors property: Router Job Attached Worker Selector.
     * 
     * @return the attachedWorkerSelectors value.
     */
    public List<AcsRouterWorkerSelector> getAttachedWorkerSelectors() {
        return this.attachedWorkerSelectors;
    }

    /**
     * Set the attachedWorkerSelectors property: Router Job Attached Worker Selector.
     * 
     * @param attachedWorkerSelectors the attachedWorkerSelectors value to set.
     * @return the AcsRouterJobClassifiedEventData object itself.
     */
    public AcsRouterJobClassifiedEventData
        setAttachedWorkerSelectors(List<AcsRouterWorkerSelector> attachedWorkerSelectors) {
        this.attachedWorkerSelectors = attachedWorkerSelectors;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobClassifiedEventData setQueueId(String queueId) {
        super.setQueueId(queueId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobClassifiedEventData setLabels(Map<String, String> labels) {
        super.setLabels(labels);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobClassifiedEventData setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobClassifiedEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobClassifiedEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobClassifiedEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("labels", getLabels(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("tags", getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("jobId", getJobId());
        jsonWriter.writeStringField("channelReference", getChannelReference());
        jsonWriter.writeStringField("channelId", getChannelId());
        jsonWriter.writeStringField("queueId", getQueueId());
        jsonWriter.writeJsonField("queueDetails", this.queueDetails);
        jsonWriter.writeStringField("classificationPolicyId", this.classificationPolicyId);
        jsonWriter.writeNumberField("priority", this.priority);
        jsonWriter.writeArrayField("attachedWorkerSelectors", this.attachedWorkerSelectors,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsRouterJobClassifiedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsRouterJobClassifiedEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsRouterJobClassifiedEventData.
     */
    public static AcsRouterJobClassifiedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsRouterJobClassifiedEventData deserializedAcsRouterJobClassifiedEventData
                = new AcsRouterJobClassifiedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("labels".equals(fieldName)) {
                    Map<String, String> labels = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobClassifiedEventData.setLabels(labels);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobClassifiedEventData.setTags(tags);
                } else if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterJobClassifiedEventData.setJobId(reader.getString());
                } else if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterJobClassifiedEventData.setChannelReference(reader.getString());
                } else if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterJobClassifiedEventData.setChannelId(reader.getString());
                } else if ("queueId".equals(fieldName)) {
                    deserializedAcsRouterJobClassifiedEventData.setQueueId(reader.getString());
                } else if ("queueDetails".equals(fieldName)) {
                    deserializedAcsRouterJobClassifiedEventData.queueDetails = AcsRouterQueueDetails.fromJson(reader);
                } else if ("classificationPolicyId".equals(fieldName)) {
                    deserializedAcsRouterJobClassifiedEventData.classificationPolicyId = reader.getString();
                } else if ("priority".equals(fieldName)) {
                    deserializedAcsRouterJobClassifiedEventData.priority = reader.getNullable(JsonReader::getInt);
                } else if ("attachedWorkerSelectors".equals(fieldName)) {
                    List<AcsRouterWorkerSelector> attachedWorkerSelectors
                        = reader.readArray(reader1 -> AcsRouterWorkerSelector.fromJson(reader1));
                    deserializedAcsRouterJobClassifiedEventData.attachedWorkerSelectors = attachedWorkerSelectors;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsRouterJobClassifiedEventData;
        });
    }
}
