// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterJobClosed event.
 */
@Fluent
public final class AcsRouterJobClosedEventData extends AcsRouterJobEventData {
    /*
     * Router Job Closed Assignment Id
     */
    private String assignmentId;

    /*
     * Router Job Closed Worker Id
     */
    private String workerId;

    /*
     * Router Job Closed Disposition Code
     */
    private String dispositionCode;

    /**
     * Creates an instance of AcsRouterJobClosedEventData class.
     */
    public AcsRouterJobClosedEventData() {
    }

    /**
     * Get the assignmentId property: Router Job Closed Assignment Id.
     * 
     * @return the assignmentId value.
     */
    public String getAssignmentId() {
        return this.assignmentId;
    }

    /**
     * Set the assignmentId property: Router Job Closed Assignment Id.
     * 
     * @param assignmentId the assignmentId value to set.
     * @return the AcsRouterJobClosedEventData object itself.
     */
    public AcsRouterJobClosedEventData setAssignmentId(String assignmentId) {
        this.assignmentId = assignmentId;
        return this;
    }

    /**
     * Get the workerId property: Router Job Closed Worker Id.
     * 
     * @return the workerId value.
     */
    public String getWorkerId() {
        return this.workerId;
    }

    /**
     * Set the workerId property: Router Job Closed Worker Id.
     * 
     * @param workerId the workerId value to set.
     * @return the AcsRouterJobClosedEventData object itself.
     */
    public AcsRouterJobClosedEventData setWorkerId(String workerId) {
        this.workerId = workerId;
        return this;
    }

    /**
     * Get the dispositionCode property: Router Job Closed Disposition Code.
     * 
     * @return the dispositionCode value.
     */
    public String getDispositionCode() {
        return this.dispositionCode;
    }

    /**
     * Set the dispositionCode property: Router Job Closed Disposition Code.
     * 
     * @param dispositionCode the dispositionCode value to set.
     * @return the AcsRouterJobClosedEventData object itself.
     */
    public AcsRouterJobClosedEventData setDispositionCode(String dispositionCode) {
        this.dispositionCode = dispositionCode;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobClosedEventData setQueueId(String queueId) {
        super.setQueueId(queueId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobClosedEventData setLabels(Map<String, String> labels) {
        super.setLabels(labels);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobClosedEventData setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobClosedEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobClosedEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobClosedEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("labels", getLabels(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("tags", getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("jobId", getJobId());
        jsonWriter.writeStringField("channelReference", getChannelReference());
        jsonWriter.writeStringField("channelId", getChannelId());
        jsonWriter.writeStringField("queueId", getQueueId());
        jsonWriter.writeStringField("assignmentId", this.assignmentId);
        jsonWriter.writeStringField("workerId", this.workerId);
        jsonWriter.writeStringField("dispositionCode", this.dispositionCode);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsRouterJobClosedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsRouterJobClosedEventData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsRouterJobClosedEventData.
     */
    public static AcsRouterJobClosedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsRouterJobClosedEventData deserializedAcsRouterJobClosedEventData = new AcsRouterJobClosedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("labels".equals(fieldName)) {
                    Map<String, String> labels = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobClosedEventData.setLabels(labels);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobClosedEventData.setTags(tags);
                } else if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterJobClosedEventData.setJobId(reader.getString());
                } else if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterJobClosedEventData.setChannelReference(reader.getString());
                } else if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterJobClosedEventData.setChannelId(reader.getString());
                } else if ("queueId".equals(fieldName)) {
                    deserializedAcsRouterJobClosedEventData.setQueueId(reader.getString());
                } else if ("assignmentId".equals(fieldName)) {
                    deserializedAcsRouterJobClosedEventData.assignmentId = reader.getString();
                } else if ("workerId".equals(fieldName)) {
                    deserializedAcsRouterJobClosedEventData.workerId = reader.getString();
                } else if ("dispositionCode".equals(fieldName)) {
                    deserializedAcsRouterJobClosedEventData.dispositionCode = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsRouterJobClosedEventData;
        });
    }
}
