// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterJobWorkerSelectorsExpired event.
 */
@Fluent
public final class AcsRouterJobWorkerSelectorsExpiredEventData extends AcsRouterJobEventData {
    /*
     * Router Job Worker Selectors Expired Requested Worker Selectors
     */
    private List<AcsRouterWorkerSelector> expiredRequestedWorkerSelectors;

    /*
     * Router Job Worker Selectors Expired Attached Worker Selectors
     */
    private List<AcsRouterWorkerSelector> expiredAttachedWorkerSelectors;

    /**
     * Creates an instance of AcsRouterJobWorkerSelectorsExpiredEventData class.
     */
    public AcsRouterJobWorkerSelectorsExpiredEventData() {
    }

    /**
     * Get the expiredRequestedWorkerSelectors property: Router Job Worker Selectors Expired Requested Worker Selectors.
     * 
     * @return the expiredRequestedWorkerSelectors value.
     */
    public List<AcsRouterWorkerSelector> getExpiredRequestedWorkerSelectors() {
        return this.expiredRequestedWorkerSelectors;
    }

    /**
     * Set the expiredRequestedWorkerSelectors property: Router Job Worker Selectors Expired Requested Worker Selectors.
     * 
     * @param expiredRequestedWorkerSelectors the expiredRequestedWorkerSelectors value to set.
     * @return the AcsRouterJobWorkerSelectorsExpiredEventData object itself.
     */
    public AcsRouterJobWorkerSelectorsExpiredEventData
        setExpiredRequestedWorkerSelectors(List<AcsRouterWorkerSelector> expiredRequestedWorkerSelectors) {
        this.expiredRequestedWorkerSelectors = expiredRequestedWorkerSelectors;
        return this;
    }

    /**
     * Get the expiredAttachedWorkerSelectors property: Router Job Worker Selectors Expired Attached Worker Selectors.
     * 
     * @return the expiredAttachedWorkerSelectors value.
     */
    public List<AcsRouterWorkerSelector> getExpiredAttachedWorkerSelectors() {
        return this.expiredAttachedWorkerSelectors;
    }

    /**
     * Set the expiredAttachedWorkerSelectors property: Router Job Worker Selectors Expired Attached Worker Selectors.
     * 
     * @param expiredAttachedWorkerSelectors the expiredAttachedWorkerSelectors value to set.
     * @return the AcsRouterJobWorkerSelectorsExpiredEventData object itself.
     */
    public AcsRouterJobWorkerSelectorsExpiredEventData
        setExpiredAttachedWorkerSelectors(List<AcsRouterWorkerSelector> expiredAttachedWorkerSelectors) {
        this.expiredAttachedWorkerSelectors = expiredAttachedWorkerSelectors;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobWorkerSelectorsExpiredEventData setQueueId(String queueId) {
        super.setQueueId(queueId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobWorkerSelectorsExpiredEventData setLabels(Map<String, String> labels) {
        super.setLabels(labels);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobWorkerSelectorsExpiredEventData setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobWorkerSelectorsExpiredEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobWorkerSelectorsExpiredEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsRouterJobWorkerSelectorsExpiredEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("labels", getLabels(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("tags", getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("jobId", getJobId());
        jsonWriter.writeStringField("channelReference", getChannelReference());
        jsonWriter.writeStringField("channelId", getChannelId());
        jsonWriter.writeStringField("queueId", getQueueId());
        jsonWriter.writeArrayField("expiredRequestedWorkerSelectors", this.expiredRequestedWorkerSelectors,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("expiredAttachedWorkerSelectors", this.expiredAttachedWorkerSelectors,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsRouterJobWorkerSelectorsExpiredEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsRouterJobWorkerSelectorsExpiredEventData if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsRouterJobWorkerSelectorsExpiredEventData.
     */
    public static AcsRouterJobWorkerSelectorsExpiredEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsRouterJobWorkerSelectorsExpiredEventData deserializedAcsRouterJobWorkerSelectorsExpiredEventData
                = new AcsRouterJobWorkerSelectorsExpiredEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("labels".equals(fieldName)) {
                    Map<String, String> labels = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobWorkerSelectorsExpiredEventData.setLabels(labels);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobWorkerSelectorsExpiredEventData.setTags(tags);
                } else if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterJobWorkerSelectorsExpiredEventData.setJobId(reader.getString());
                } else if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterJobWorkerSelectorsExpiredEventData.setChannelReference(reader.getString());
                } else if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterJobWorkerSelectorsExpiredEventData.setChannelId(reader.getString());
                } else if ("queueId".equals(fieldName)) {
                    deserializedAcsRouterJobWorkerSelectorsExpiredEventData.setQueueId(reader.getString());
                } else if ("expiredRequestedWorkerSelectors".equals(fieldName)) {
                    List<AcsRouterWorkerSelector> expiredRequestedWorkerSelectors
                        = reader.readArray(reader1 -> AcsRouterWorkerSelector.fromJson(reader1));
                    deserializedAcsRouterJobWorkerSelectorsExpiredEventData.expiredRequestedWorkerSelectors
                        = expiredRequestedWorkerSelectors;
                } else if ("expiredAttachedWorkerSelectors".equals(fieldName)) {
                    List<AcsRouterWorkerSelector> expiredAttachedWorkerSelectors
                        = reader.readArray(reader1 -> AcsRouterWorkerSelector.fromJson(reader1));
                    deserializedAcsRouterJobWorkerSelectorsExpiredEventData.expiredAttachedWorkerSelectors
                        = expiredAttachedWorkerSelectors;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsRouterJobWorkerSelectorsExpiredEventData;
        });
    }
}
