// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for an Microsoft.Communication.UserDisconnected event.
 */
@Fluent
public final class AcsUserDisconnectedEventData implements JsonSerializable<AcsUserDisconnectedEventData> {
    /*
     * The communication identifier of the user who was disconnected
     */
    private CommunicationIdentifierModel userCommunicationIdentifier;

    /**
     * Creates an instance of AcsUserDisconnectedEventData class.
     */
    public AcsUserDisconnectedEventData() {
    }

    /**
     * Get the userCommunicationIdentifier property: The communication identifier of the user who was disconnected.
     * 
     * @return the userCommunicationIdentifier value.
     */
    public CommunicationIdentifierModel getUserCommunicationIdentifier() {
        return this.userCommunicationIdentifier;
    }

    /**
     * Set the userCommunicationIdentifier property: The communication identifier of the user who was disconnected.
     * 
     * @param userCommunicationIdentifier the userCommunicationIdentifier value to set.
     * @return the AcsUserDisconnectedEventData object itself.
     */
    public AcsUserDisconnectedEventData
        setUserCommunicationIdentifier(CommunicationIdentifierModel userCommunicationIdentifier) {
        this.userCommunicationIdentifier = userCommunicationIdentifier;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("userCommunicationIdentifier", this.userCommunicationIdentifier);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsUserDisconnectedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsUserDisconnectedEventData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsUserDisconnectedEventData.
     */
    public static AcsUserDisconnectedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsUserDisconnectedEventData deserializedAcsUserDisconnectedEventData = new AcsUserDisconnectedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("userCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsUserDisconnectedEventData.userCommunicationIdentifier
                        = CommunicationIdentifierModel.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsUserDisconnectedEventData;
        });
    }
}
