// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Information related to a an expired gateway token for a self-hosted gateway deployment.
 */
@Fluent
public final class ApiManagementExpiredGatewayTokenProperties
    implements JsonSerializable<ApiManagementExpiredGatewayTokenProperties> {
    /*
     * Timestamp when the gateway token has expired.
     */
    private OffsetDateTime expiresOn;

    /**
     * Creates an instance of ApiManagementExpiredGatewayTokenProperties class.
     */
    public ApiManagementExpiredGatewayTokenProperties() {
    }

    /**
     * Get the expiresOn property: Timestamp when the gateway token has expired.
     * 
     * @return the expiresOn value.
     */
    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    /**
     * Set the expiresOn property: Timestamp when the gateway token has expired.
     * 
     * @param expiresOn the expiresOn value to set.
     * @return the ApiManagementExpiredGatewayTokenProperties object itself.
     */
    public ApiManagementExpiredGatewayTokenProperties setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("expiredAtUtc",
            this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementExpiredGatewayTokenProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementExpiredGatewayTokenProperties if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiManagementExpiredGatewayTokenProperties.
     */
    public static ApiManagementExpiredGatewayTokenProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementExpiredGatewayTokenProperties deserializedApiManagementExpiredGatewayTokenProperties
                = new ApiManagementExpiredGatewayTokenProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("expiredAtUtc".equals(fieldName)) {
                    deserializedApiManagementExpiredGatewayTokenProperties.expiresOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementExpiredGatewayTokenProperties;
        });
    }
}
