// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.ContainerService.NodePoolRollingFailed event.
 */
@Fluent
public final class ContainerServiceNodePoolRollingFailedEventData extends ContainerServiceNodePoolRollingEventData {
    /**
     * Creates an instance of ContainerServiceNodePoolRollingFailedEventData class.
     */
    public ContainerServiceNodePoolRollingFailedEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ContainerServiceNodePoolRollingFailedEventData setNodePoolName(String nodePoolName) {
        super.setNodePoolName(nodePoolName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nodePoolName", getNodePoolName());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerServiceNodePoolRollingFailedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerServiceNodePoolRollingFailedEventData if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerServiceNodePoolRollingFailedEventData.
     */
    public static ContainerServiceNodePoolRollingFailedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerServiceNodePoolRollingFailedEventData deserializedContainerServiceNodePoolRollingFailedEventData
                = new ContainerServiceNodePoolRollingFailedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nodePoolName".equals(fieldName)) {
                    deserializedContainerServiceNodePoolRollingFailedEventData.setNodePoolName(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerServiceNodePoolRollingFailedEventData;
        });
    }
}
