// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Configured state of the client. The value could be Enabled or Disabled.
 */
public final class EventGridMqttClientState extends ExpandableStringEnum<EventGridMqttClientState> {
    /**
     * Static value Enabled for EventGridMqttClientState.
     */
    public static final EventGridMqttClientState ENABLED = fromString("Enabled");

    /**
     * Static value Disabled for EventGridMqttClientState.
     */
    public static final EventGridMqttClientState DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of EventGridMqttClientState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public EventGridMqttClientState() {
    }

    /**
     * Creates or finds a EventGridMqttClientState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding EventGridMqttClientState.
     */
    public static EventGridMqttClientState fromString(String name) {
        return fromString(name, EventGridMqttClientState.class);
    }

    /**
     * Gets known EventGridMqttClientState values.
     * 
     * @return known EventGridMqttClientState values.
     */
    public static Collection<EventGridMqttClientState> values() {
        return values(EventGridMqttClientState.class);
    }
}
