// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Schema of the Data property of an EventGridEvent for a Geofence event (GeofenceEntered, GeofenceExited,
 * GeofenceResult).
 */
@Fluent
public class MapsGeofenceEventProperties implements JsonSerializable<MapsGeofenceEventProperties> {
    /*
     * Lists of the geometry ID of the geofence which is expired relative to the user time in the request.
     */
    private List<String> expiredGeofenceGeometryId;

    /*
     * Lists the fence geometries that either fully contain the coordinate position or have an overlap with the
     * searchBuffer around the fence.
     */
    private List<MapsGeofenceGeometry> geometries;

    /*
     * Lists of the geometry ID of the geofence which is in invalid period relative to the user time in the request.
     */
    private List<String> invalidPeriodGeofenceGeometryId;

    /*
     * True if at least one event is published to the Azure Maps event subscriber, false if no event is published to the
     * Azure Maps event subscriber.
     */
    private Boolean isEventPublished;

    /**
     * Creates an instance of MapsGeofenceEventProperties class.
     */
    public MapsGeofenceEventProperties() {
    }

    /**
     * Get the expiredGeofenceGeometryId property: Lists of the geometry ID of the geofence which is expired relative to
     * the user time in the request.
     * 
     * @return the expiredGeofenceGeometryId value.
     */
    public List<String> getExpiredGeofenceGeometryId() {
        return this.expiredGeofenceGeometryId;
    }

    /**
     * Set the expiredGeofenceGeometryId property: Lists of the geometry ID of the geofence which is expired relative to
     * the user time in the request.
     * 
     * @param expiredGeofenceGeometryId the expiredGeofenceGeometryId value to set.
     * @return the MapsGeofenceEventProperties object itself.
     */
    public MapsGeofenceEventProperties setExpiredGeofenceGeometryId(List<String> expiredGeofenceGeometryId) {
        this.expiredGeofenceGeometryId = expiredGeofenceGeometryId;
        return this;
    }

    /**
     * Get the geometries property: Lists the fence geometries that either fully contain the coordinate position or have
     * an overlap with the searchBuffer around the fence.
     * 
     * @return the geometries value.
     */
    public List<MapsGeofenceGeometry> getGeometries() {
        return this.geometries;
    }

    /**
     * Set the geometries property: Lists the fence geometries that either fully contain the coordinate position or have
     * an overlap with the searchBuffer around the fence.
     * 
     * @param geometries the geometries value to set.
     * @return the MapsGeofenceEventProperties object itself.
     */
    public MapsGeofenceEventProperties setGeometries(List<MapsGeofenceGeometry> geometries) {
        this.geometries = geometries;
        return this;
    }

    /**
     * Get the invalidPeriodGeofenceGeometryId property: Lists of the geometry ID of the geofence which is in invalid
     * period relative to the user time in the request.
     * 
     * @return the invalidPeriodGeofenceGeometryId value.
     */
    public List<String> getInvalidPeriodGeofenceGeometryId() {
        return this.invalidPeriodGeofenceGeometryId;
    }

    /**
     * Set the invalidPeriodGeofenceGeometryId property: Lists of the geometry ID of the geofence which is in invalid
     * period relative to the user time in the request.
     * 
     * @param invalidPeriodGeofenceGeometryId the invalidPeriodGeofenceGeometryId value to set.
     * @return the MapsGeofenceEventProperties object itself.
     */
    public MapsGeofenceEventProperties
        setInvalidPeriodGeofenceGeometryId(List<String> invalidPeriodGeofenceGeometryId) {
        this.invalidPeriodGeofenceGeometryId = invalidPeriodGeofenceGeometryId;
        return this;
    }

    /**
     * Get the isEventPublished property: True if at least one event is published to the Azure Maps event subscriber,
     * false if no event is published to the Azure Maps event subscriber.
     * 
     * @return the isEventPublished value.
     */
    public Boolean isEventPublished() {
        return this.isEventPublished;
    }

    /**
     * Set the isEventPublished property: True if at least one event is published to the Azure Maps event subscriber,
     * false if no event is published to the Azure Maps event subscriber.
     * 
     * @param isEventPublished the isEventPublished value to set.
     * @return the MapsGeofenceEventProperties object itself.
     */
    public MapsGeofenceEventProperties setIsEventPublished(Boolean isEventPublished) {
        this.isEventPublished = isEventPublished;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("expiredGeofenceGeometryId", this.expiredGeofenceGeometryId,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("geometries", this.geometries, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("invalidPeriodGeofenceGeometryId", this.invalidPeriodGeofenceGeometryId,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isEventPublished", this.isEventPublished);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MapsGeofenceEventProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MapsGeofenceEventProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MapsGeofenceEventProperties.
     */
    public static MapsGeofenceEventProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MapsGeofenceEventProperties deserializedMapsGeofenceEventProperties = new MapsGeofenceEventProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("expiredGeofenceGeometryId".equals(fieldName)) {
                    List<String> expiredGeofenceGeometryId = reader.readArray(reader1 -> reader1.getString());
                    deserializedMapsGeofenceEventProperties.expiredGeofenceGeometryId = expiredGeofenceGeometryId;
                } else if ("geometries".equals(fieldName)) {
                    List<MapsGeofenceGeometry> geometries
                        = reader.readArray(reader1 -> MapsGeofenceGeometry.fromJson(reader1));
                    deserializedMapsGeofenceEventProperties.geometries = geometries;
                } else if ("invalidPeriodGeofenceGeometryId".equals(fieldName)) {
                    List<String> invalidPeriodGeofenceGeometryId = reader.readArray(reader1 -> reader1.getString());
                    deserializedMapsGeofenceEventProperties.invalidPeriodGeofenceGeometryId
                        = invalidPeriodGeofenceGeometryId;
                } else if ("isEventPublished".equals(fieldName)) {
                    deserializedMapsGeofenceEventProperties.isEventPublished
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMapsGeofenceEventProperties;
        });
    }
}
