// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Job output error event data. Schema of the data property of an EventGridEvent for a Microsoft.Media.JobOutputErrored
 * event.
 */
@Fluent
public final class MediaJobOutputErroredEventData extends MediaJobOutputStateChangeEventData {
    /*
     * The previous state of the Job.
     */
    private MediaJobState previousState;

    /**
     * Creates an instance of MediaJobOutputErroredEventData class.
     */
    public MediaJobOutputErroredEventData() {
    }

    /**
     * Get the previousState property: The previous state of the Job.
     * 
     * @return the previousState value.
     */
    @Override
    public MediaJobState getPreviousState() {
        return this.previousState;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MediaJobOutputErroredEventData setOutput(MediaJobOutput output) {
        super.setOutput(output);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MediaJobOutputErroredEventData setJobCorrelationData(Map<String, String> jobCorrelationData) {
        super.setJobCorrelationData(jobCorrelationData);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("output", getOutput());
        jsonWriter.writeMapField("jobCorrelationData", getJobCorrelationData(),
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MediaJobOutputErroredEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MediaJobOutputErroredEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MediaJobOutputErroredEventData.
     */
    public static MediaJobOutputErroredEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MediaJobOutputErroredEventData deserializedMediaJobOutputErroredEventData
                = new MediaJobOutputErroredEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("previousState".equals(fieldName)) {
                    deserializedMediaJobOutputErroredEventData.previousState
                        = MediaJobState.fromString(reader.getString());
                } else if ("output".equals(fieldName)) {
                    deserializedMediaJobOutputErroredEventData.setOutput(MediaJobOutput.fromJson(reader));
                } else if ("jobCorrelationData".equals(fieldName)) {
                    Map<String, String> jobCorrelationData = reader.readMap(reader1 -> reader1.getString());
                    deserializedMediaJobOutputErroredEventData.setJobCorrelationData(jobCorrelationData);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMediaJobOutputErroredEventData;
        });
    }
}
