// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Storage.BlobDeleted event.
 */
@Fluent
public final class StorageBlobDeletedEventData implements JsonSerializable<StorageBlobDeletedEventData> {
    /*
     * The name of the API/operation that triggered this event.
     */
    private String api;

    /*
     * A request id provided by the client of the storage API operation that triggered this event.
     */
    private String clientRequestId;

    /*
     * The request id generated by the Storage service for the storage API operation that triggered this event.
     */
    private String requestId;

    /*
     * The content type of the blob. This is the same as what would be returned in the Content-Type header from the
     * blob.
     */
    private String contentType;

    /*
     * The type of blob.
     */
    private String blobType;

    /*
     * The path to the blob.
     */
    private String url;

    /*
     * An opaque string value representing the logical sequence of events for any particular blob name. Users can use
     * standard string comparison to understand the relative sequence of two events on the same blob name.
     */
    private String sequencer;

    /*
     * The identity of the requester that triggered this event.
     */
    private String identity;

    /*
     * For service use only. Diagnostic data occasionally included by the Azure Storage service. This property should be
     * ignored by event consumers.
     */
    private Object storageDiagnostics;

    /**
     * Creates an instance of StorageBlobDeletedEventData class.
     */
    public StorageBlobDeletedEventData() {
    }

    /**
     * Get the api property: The name of the API/operation that triggered this event.
     * 
     * @return the api value.
     */
    public String getApi() {
        return this.api;
    }

    /**
     * Set the api property: The name of the API/operation that triggered this event.
     * 
     * @param api the api value to set.
     * @return the StorageBlobDeletedEventData object itself.
     */
    public StorageBlobDeletedEventData setApi(String api) {
        this.api = api;
        return this;
    }

    /**
     * Get the clientRequestId property: A request id provided by the client of the storage API operation that triggered
     * this event.
     * 
     * @return the clientRequestId value.
     */
    public String getClientRequestId() {
        return this.clientRequestId;
    }

    /**
     * Set the clientRequestId property: A request id provided by the client of the storage API operation that triggered
     * this event.
     * 
     * @param clientRequestId the clientRequestId value to set.
     * @return the StorageBlobDeletedEventData object itself.
     */
    public StorageBlobDeletedEventData setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    /**
     * Get the requestId property: The request id generated by the Storage service for the storage API operation that
     * triggered this event.
     * 
     * @return the requestId value.
     */
    public String getRequestId() {
        return this.requestId;
    }

    /**
     * Set the requestId property: The request id generated by the Storage service for the storage API operation that
     * triggered this event.
     * 
     * @param requestId the requestId value to set.
     * @return the StorageBlobDeletedEventData object itself.
     */
    public StorageBlobDeletedEventData setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    /**
     * Get the contentType property: The content type of the blob. This is the same as what would be returned in the
     * Content-Type header from the blob.
     * 
     * @return the contentType value.
     */
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: The content type of the blob. This is the same as what would be returned in the
     * Content-Type header from the blob.
     * 
     * @param contentType the contentType value to set.
     * @return the StorageBlobDeletedEventData object itself.
     */
    public StorageBlobDeletedEventData setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the blobType property: The type of blob.
     * 
     * @return the blobType value.
     */
    public String getBlobType() {
        return this.blobType;
    }

    /**
     * Set the blobType property: The type of blob.
     * 
     * @param blobType the blobType value to set.
     * @return the StorageBlobDeletedEventData object itself.
     */
    public StorageBlobDeletedEventData setBlobType(String blobType) {
        this.blobType = blobType;
        return this;
    }

    /**
     * Get the url property: The path to the blob.
     * 
     * @return the url value.
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * Set the url property: The path to the blob.
     * 
     * @param url the url value to set.
     * @return the StorageBlobDeletedEventData object itself.
     */
    public StorageBlobDeletedEventData setUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Get the sequencer property: An opaque string value representing the logical sequence of events for any particular
     * blob name. Users can use standard string comparison to understand the relative sequence of two events on the same
     * blob name.
     * 
     * @return the sequencer value.
     */
    public String getSequencer() {
        return this.sequencer;
    }

    /**
     * Set the sequencer property: An opaque string value representing the logical sequence of events for any particular
     * blob name. Users can use standard string comparison to understand the relative sequence of two events on the same
     * blob name.
     * 
     * @param sequencer the sequencer value to set.
     * @return the StorageBlobDeletedEventData object itself.
     */
    public StorageBlobDeletedEventData setSequencer(String sequencer) {
        this.sequencer = sequencer;
        return this;
    }

    /**
     * Get the identity property: The identity of the requester that triggered this event.
     * 
     * @return the identity value.
     */
    public String getIdentity() {
        return this.identity;
    }

    /**
     * Set the identity property: The identity of the requester that triggered this event.
     * 
     * @param identity the identity value to set.
     * @return the StorageBlobDeletedEventData object itself.
     */
    public StorageBlobDeletedEventData setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the storageDiagnostics property: For service use only. Diagnostic data occasionally included by the Azure
     * Storage service. This property should be ignored by event consumers.
     * 
     * @return the storageDiagnostics value.
     */
    public Object getStorageDiagnostics() {
        return this.storageDiagnostics;
    }

    /**
     * Set the storageDiagnostics property: For service use only. Diagnostic data occasionally included by the Azure
     * Storage service. This property should be ignored by event consumers.
     * 
     * @param storageDiagnostics the storageDiagnostics value to set.
     * @return the StorageBlobDeletedEventData object itself.
     */
    public StorageBlobDeletedEventData setStorageDiagnostics(Object storageDiagnostics) {
        this.storageDiagnostics = storageDiagnostics;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("api", this.api);
        jsonWriter.writeStringField("clientRequestId", this.clientRequestId);
        jsonWriter.writeStringField("requestId", this.requestId);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeStringField("blobType", this.blobType);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("sequencer", this.sequencer);
        jsonWriter.writeStringField("identity", this.identity);
        jsonWriter.writeUntypedField("storageDiagnostics", this.storageDiagnostics);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageBlobDeletedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageBlobDeletedEventData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageBlobDeletedEventData.
     */
    public static StorageBlobDeletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageBlobDeletedEventData deserializedStorageBlobDeletedEventData = new StorageBlobDeletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("api".equals(fieldName)) {
                    deserializedStorageBlobDeletedEventData.api = reader.getString();
                } else if ("clientRequestId".equals(fieldName)) {
                    deserializedStorageBlobDeletedEventData.clientRequestId = reader.getString();
                } else if ("requestId".equals(fieldName)) {
                    deserializedStorageBlobDeletedEventData.requestId = reader.getString();
                } else if ("contentType".equals(fieldName)) {
                    deserializedStorageBlobDeletedEventData.contentType = reader.getString();
                } else if ("blobType".equals(fieldName)) {
                    deserializedStorageBlobDeletedEventData.blobType = reader.getString();
                } else if ("url".equals(fieldName)) {
                    deserializedStorageBlobDeletedEventData.url = reader.getString();
                } else if ("sequencer".equals(fieldName)) {
                    deserializedStorageBlobDeletedEventData.sequencer = reader.getString();
                } else if ("identity".equals(fieldName)) {
                    deserializedStorageBlobDeletedEventData.identity = reader.getString();
                } else if ("storageDiagnostics".equals(fieldName)) {
                    deserializedStorageBlobDeletedEventData.storageDiagnostics = reader.readUntyped();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageBlobDeletedEventData;
        });
    }
}
