// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Storage.LifecyclePolicyCompleted event.
 */
@Fluent
public final class StorageLifecyclePolicyCompletedEventData
    implements JsonSerializable<StorageLifecyclePolicyCompletedEventData> {
    /*
     * The time the policy task was scheduled.
     */
    private String scheduleTime;

    /*
     * Policy run status of an account in a Blob Management cycle.
     */
    private StorageLifecyclePolicyRunSummary policyRunSummary;

    /*
     * Execution statistics of a specific policy action in a Blob Management cycle.
     */
    private StorageLifecyclePolicyActionSummaryDetail deleteSummary;

    /*
     * Execution statistics of a specific policy action in a Blob Management cycle.
     */
    private StorageLifecyclePolicyActionSummaryDetail tierToCoolSummary;

    /*
     * Execution statistics of a specific policy action in a Blob Management cycle.
     */
    private StorageLifecyclePolicyActionSummaryDetail tierToColdSummary;

    /*
     * Execution statistics of a specific policy action in a Blob Management cycle.
     */
    private StorageLifecyclePolicyActionSummaryDetail tierToArchiveSummary;

    /**
     * Creates an instance of StorageLifecyclePolicyCompletedEventData class.
     */
    public StorageLifecyclePolicyCompletedEventData() {
    }

    /**
     * Get the scheduleTime property: The time the policy task was scheduled.
     * 
     * @return the scheduleTime value.
     */
    public String getScheduleTime() {
        return this.scheduleTime;
    }

    /**
     * Set the scheduleTime property: The time the policy task was scheduled.
     * 
     * @param scheduleTime the scheduleTime value to set.
     * @return the StorageLifecyclePolicyCompletedEventData object itself.
     */
    public StorageLifecyclePolicyCompletedEventData setScheduleTime(String scheduleTime) {
        this.scheduleTime = scheduleTime;
        return this;
    }

    /**
     * Get the policyRunSummary property: Policy run status of an account in a Blob Management cycle.
     * 
     * @return the policyRunSummary value.
     */
    public StorageLifecyclePolicyRunSummary getPolicyRunSummary() {
        return this.policyRunSummary;
    }

    /**
     * Set the policyRunSummary property: Policy run status of an account in a Blob Management cycle.
     * 
     * @param policyRunSummary the policyRunSummary value to set.
     * @return the StorageLifecyclePolicyCompletedEventData object itself.
     */
    public StorageLifecyclePolicyCompletedEventData
        setPolicyRunSummary(StorageLifecyclePolicyRunSummary policyRunSummary) {
        this.policyRunSummary = policyRunSummary;
        return this;
    }

    /**
     * Get the deleteSummary property: Execution statistics of a specific policy action in a Blob Management cycle.
     * 
     * @return the deleteSummary value.
     */
    public StorageLifecyclePolicyActionSummaryDetail getDeleteSummary() {
        return this.deleteSummary;
    }

    /**
     * Set the deleteSummary property: Execution statistics of a specific policy action in a Blob Management cycle.
     * 
     * @param deleteSummary the deleteSummary value to set.
     * @return the StorageLifecyclePolicyCompletedEventData object itself.
     */
    public StorageLifecyclePolicyCompletedEventData
        setDeleteSummary(StorageLifecyclePolicyActionSummaryDetail deleteSummary) {
        this.deleteSummary = deleteSummary;
        return this;
    }

    /**
     * Get the tierToCoolSummary property: Execution statistics of a specific policy action in a Blob Management cycle.
     * 
     * @return the tierToCoolSummary value.
     */
    public StorageLifecyclePolicyActionSummaryDetail getTierToCoolSummary() {
        return this.tierToCoolSummary;
    }

    /**
     * Set the tierToCoolSummary property: Execution statistics of a specific policy action in a Blob Management cycle.
     * 
     * @param tierToCoolSummary the tierToCoolSummary value to set.
     * @return the StorageLifecyclePolicyCompletedEventData object itself.
     */
    public StorageLifecyclePolicyCompletedEventData
        setTierToCoolSummary(StorageLifecyclePolicyActionSummaryDetail tierToCoolSummary) {
        this.tierToCoolSummary = tierToCoolSummary;
        return this;
    }

    /**
     * Get the tierToColdSummary property: Execution statistics of a specific policy action in a Blob Management cycle.
     * 
     * @return the tierToColdSummary value.
     */
    public StorageLifecyclePolicyActionSummaryDetail getTierToColdSummary() {
        return this.tierToColdSummary;
    }

    /**
     * Set the tierToColdSummary property: Execution statistics of a specific policy action in a Blob Management cycle.
     * 
     * @param tierToColdSummary the tierToColdSummary value to set.
     * @return the StorageLifecyclePolicyCompletedEventData object itself.
     */
    public StorageLifecyclePolicyCompletedEventData
        setTierToColdSummary(StorageLifecyclePolicyActionSummaryDetail tierToColdSummary) {
        this.tierToColdSummary = tierToColdSummary;
        return this;
    }

    /**
     * Get the tierToArchiveSummary property: Execution statistics of a specific policy action in a Blob Management
     * cycle.
     * 
     * @return the tierToArchiveSummary value.
     */
    public StorageLifecyclePolicyActionSummaryDetail getTierToArchiveSummary() {
        return this.tierToArchiveSummary;
    }

    /**
     * Set the tierToArchiveSummary property: Execution statistics of a specific policy action in a Blob Management
     * cycle.
     * 
     * @param tierToArchiveSummary the tierToArchiveSummary value to set.
     * @return the StorageLifecyclePolicyCompletedEventData object itself.
     */
    public StorageLifecyclePolicyCompletedEventData
        setTierToArchiveSummary(StorageLifecyclePolicyActionSummaryDetail tierToArchiveSummary) {
        this.tierToArchiveSummary = tierToArchiveSummary;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scheduleTime", this.scheduleTime);
        jsonWriter.writeJsonField("policyRunSummary", this.policyRunSummary);
        jsonWriter.writeJsonField("deleteSummary", this.deleteSummary);
        jsonWriter.writeJsonField("tierToCoolSummary", this.tierToCoolSummary);
        jsonWriter.writeJsonField("tierToColdSummary", this.tierToColdSummary);
        jsonWriter.writeJsonField("tierToArchiveSummary", this.tierToArchiveSummary);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageLifecyclePolicyCompletedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageLifecyclePolicyCompletedEventData if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageLifecyclePolicyCompletedEventData.
     */
    public static StorageLifecyclePolicyCompletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageLifecyclePolicyCompletedEventData deserializedStorageLifecyclePolicyCompletedEventData
                = new StorageLifecyclePolicyCompletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scheduleTime".equals(fieldName)) {
                    deserializedStorageLifecyclePolicyCompletedEventData.scheduleTime = reader.getString();
                } else if ("policyRunSummary".equals(fieldName)) {
                    deserializedStorageLifecyclePolicyCompletedEventData.policyRunSummary
                        = StorageLifecyclePolicyRunSummary.fromJson(reader);
                } else if ("deleteSummary".equals(fieldName)) {
                    deserializedStorageLifecyclePolicyCompletedEventData.deleteSummary
                        = StorageLifecyclePolicyActionSummaryDetail.fromJson(reader);
                } else if ("tierToCoolSummary".equals(fieldName)) {
                    deserializedStorageLifecyclePolicyCompletedEventData.tierToCoolSummary
                        = StorageLifecyclePolicyActionSummaryDetail.fromJson(reader);
                } else if ("tierToColdSummary".equals(fieldName)) {
                    deserializedStorageLifecyclePolicyCompletedEventData.tierToColdSummary
                        = StorageLifecyclePolicyActionSummaryDetail.fromJson(reader);
                } else if ("tierToArchiveSummary".equals(fieldName)) {
                    deserializedStorageLifecyclePolicyCompletedEventData.tierToArchiveSummary
                        = StorageLifecyclePolicyActionSummaryDetail.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageLifecyclePolicyCompletedEventData;
        });
    }
}
