/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsCallGroupProperties;
import com.azure.messaging.eventgrid.systemevents.AcsCallParticipantEventData;
import com.azure.messaging.eventgrid.systemevents.AcsCallParticipantProperties;
import com.azure.messaging.eventgrid.systemevents.AcsCallRoomProperties;
import java.io.IOException;

public final class AcsCallParticipantRemovedEventData
extends AcsCallParticipantEventData {
    @Override
    public AcsCallParticipantRemovedEventData setUser(AcsCallParticipantProperties user) {
        super.setUser(user);
        return this;
    }

    @Override
    public AcsCallParticipantRemovedEventData setDisplayName(String displayName) {
        super.setDisplayName(displayName);
        return this;
    }

    @Override
    public AcsCallParticipantRemovedEventData setParticipantId(String participantId) {
        super.setParticipantId(participantId);
        return this;
    }

    @Override
    public AcsCallParticipantRemovedEventData setUserAgent(String userAgent) {
        super.setUserAgent(userAgent);
        return this;
    }

    @Override
    public AcsCallParticipantRemovedEventData setStartedBy(AcsCallParticipantProperties startedBy) {
        super.setStartedBy(startedBy);
        return this;
    }

    @Override
    public AcsCallParticipantRemovedEventData setServerCallId(String serverCallId) {
        super.setServerCallId(serverCallId);
        return this;
    }

    @Override
    public AcsCallParticipantRemovedEventData setGroup(AcsCallGroupProperties group) {
        super.setGroup(group);
        return this;
    }

    @Override
    public AcsCallParticipantRemovedEventData setRoom(AcsCallRoomProperties room) {
        super.setRoom(room);
        return this;
    }

    @Override
    public AcsCallParticipantRemovedEventData setIsTwoParty(Boolean isTwoParty) {
        super.setIsTwoParty(isTwoParty);
        return this;
    }

    @Override
    public AcsCallParticipantRemovedEventData setCorrelationId(String correlationId) {
        super.setCorrelationId(correlationId);
        return this;
    }

    @Override
    public AcsCallParticipantRemovedEventData setIsRoomsCall(Boolean isRoomsCall) {
        super.setIsRoomsCall(isRoomsCall);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("startedBy", (JsonSerializable)this.getStartedBy());
        jsonWriter.writeStringField("serverCallId", this.getServerCallId());
        jsonWriter.writeStringField("correlationId", this.getCorrelationId());
        jsonWriter.writeJsonField("group", (JsonSerializable)this.getGroup());
        jsonWriter.writeJsonField("room", (JsonSerializable)this.getRoom());
        jsonWriter.writeBooleanField("isTwoParty", this.isTwoParty());
        jsonWriter.writeBooleanField("isRoomsCall", this.isRoomsCall());
        jsonWriter.writeJsonField("user", (JsonSerializable)this.getUser());
        jsonWriter.writeStringField("displayName", this.getDisplayName());
        jsonWriter.writeStringField("participantId", this.getParticipantId());
        jsonWriter.writeStringField("userAgent", this.getUserAgent());
        return jsonWriter.writeEndObject();
    }

    public static AcsCallParticipantRemovedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsCallParticipantRemovedEventData)jsonReader.readObject(reader -> {
            AcsCallParticipantRemovedEventData deserializedAcsCallParticipantRemovedEventData = new AcsCallParticipantRemovedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startedBy".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setStartedBy(AcsCallParticipantProperties.fromJson(reader));
                    continue;
                }
                if ("serverCallId".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setServerCallId(reader.getString());
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setCorrelationId(reader.getString());
                    continue;
                }
                if ("group".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setGroup(AcsCallGroupProperties.fromJson(reader));
                    continue;
                }
                if ("room".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setRoom(AcsCallRoomProperties.fromJson(reader));
                    continue;
                }
                if ("isTwoParty".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setIsTwoParty((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("isRoomsCall".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setIsRoomsCall((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("user".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setUser(AcsCallParticipantProperties.fromJson(reader));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setDisplayName(reader.getString());
                    continue;
                }
                if ("participantId".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setParticipantId(reader.getString());
                    continue;
                }
                if ("userAgent".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setUserAgent(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsCallParticipantRemovedEventData;
        });
    }
}

