/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsCallGroupProperties;
import com.azure.messaging.eventgrid.systemevents.AcsCallParticipantProperties;
import com.azure.messaging.eventgrid.systemevents.AcsCallRoomProperties;
import java.io.IOException;

public class AcsCallingEventProperties
implements JsonSerializable<AcsCallingEventProperties> {
    private AcsCallParticipantProperties startedBy;
    private String serverCallId;
    private AcsCallGroupProperties group;
    private AcsCallRoomProperties room;
    private Boolean isTwoParty;
    private String correlationId;
    private Boolean isRoomsCall;

    public AcsCallParticipantProperties getStartedBy() {
        return this.startedBy;
    }

    public AcsCallingEventProperties setStartedBy(AcsCallParticipantProperties startedBy) {
        this.startedBy = startedBy;
        return this;
    }

    public String getServerCallId() {
        return this.serverCallId;
    }

    public AcsCallingEventProperties setServerCallId(String serverCallId) {
        this.serverCallId = serverCallId;
        return this;
    }

    public AcsCallGroupProperties getGroup() {
        return this.group;
    }

    public AcsCallingEventProperties setGroup(AcsCallGroupProperties group) {
        this.group = group;
        return this;
    }

    public AcsCallRoomProperties getRoom() {
        return this.room;
    }

    public AcsCallingEventProperties setRoom(AcsCallRoomProperties room) {
        this.room = room;
        return this;
    }

    public Boolean isTwoParty() {
        return this.isTwoParty;
    }

    public AcsCallingEventProperties setIsTwoParty(Boolean isTwoParty) {
        this.isTwoParty = isTwoParty;
        return this;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public AcsCallingEventProperties setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public Boolean isRoomsCall() {
        return this.isRoomsCall;
    }

    public AcsCallingEventProperties setIsRoomsCall(Boolean isRoomsCall) {
        this.isRoomsCall = isRoomsCall;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("startedBy", (JsonSerializable)this.startedBy);
        jsonWriter.writeStringField("serverCallId", this.serverCallId);
        jsonWriter.writeStringField("correlationId", this.correlationId);
        jsonWriter.writeJsonField("group", (JsonSerializable)this.group);
        jsonWriter.writeJsonField("room", (JsonSerializable)this.room);
        jsonWriter.writeBooleanField("isTwoParty", this.isTwoParty);
        jsonWriter.writeBooleanField("isRoomsCall", this.isRoomsCall);
        return jsonWriter.writeEndObject();
    }

    public static AcsCallingEventProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AcsCallingEventProperties)jsonReader.readObject(reader -> {
            AcsCallingEventProperties deserializedAcsCallingEventProperties = new AcsCallingEventProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startedBy".equals(fieldName)) {
                    deserializedAcsCallingEventProperties.startedBy = AcsCallParticipantProperties.fromJson(reader);
                    continue;
                }
                if ("serverCallId".equals(fieldName)) {
                    deserializedAcsCallingEventProperties.serverCallId = reader.getString();
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedAcsCallingEventProperties.correlationId = reader.getString();
                    continue;
                }
                if ("group".equals(fieldName)) {
                    deserializedAcsCallingEventProperties.group = AcsCallGroupProperties.fromJson(reader);
                    continue;
                }
                if ("room".equals(fieldName)) {
                    deserializedAcsCallingEventProperties.room = AcsCallRoomProperties.fromJson(reader);
                    continue;
                }
                if ("isTwoParty".equals(fieldName)) {
                    deserializedAcsCallingEventProperties.isTwoParty = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isRoomsCall".equals(fieldName)) {
                    deserializedAcsCallingEventProperties.isRoomsCall = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsCallingEventProperties;
        });
    }
}

