/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatMessageEventBaseProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class AcsChatMessageReceivedEventData
extends AcsChatMessageEventBaseProperties {
    private String messageBody;
    private Map<String, String> metadata;

    public String getMessageBody() {
        return this.messageBody;
    }

    public AcsChatMessageReceivedEventData setMessageBody(String messageBody) {
        this.messageBody = messageBody;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public AcsChatMessageReceivedEventData setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public AcsChatMessageReceivedEventData setMessageId(String messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public AcsChatMessageReceivedEventData setSenderCommunicationIdentifier(CommunicationIdentifierModel senderCommunicationIdentifier) {
        super.setSenderCommunicationIdentifier(senderCommunicationIdentifier);
        return this;
    }

    @Override
    public AcsChatMessageReceivedEventData setSenderDisplayName(String senderDisplayName) {
        super.setSenderDisplayName(senderDisplayName);
        return this;
    }

    @Override
    public AcsChatMessageReceivedEventData setComposeTime(OffsetDateTime composeTime) {
        super.setComposeTime(composeTime);
        return this;
    }

    @Override
    public AcsChatMessageReceivedEventData setType(String type) {
        super.setType(type);
        return this;
    }

    @Override
    public AcsChatMessageReceivedEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AcsChatMessageReceivedEventData setRecipientCommunicationIdentifier(CommunicationIdentifierModel recipientCommunicationIdentifier) {
        super.setRecipientCommunicationIdentifier(recipientCommunicationIdentifier);
        return this;
    }

    @Override
    public AcsChatMessageReceivedEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatMessageReceivedEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("messageId", this.getMessageId());
        jsonWriter.writeJsonField("senderCommunicationIdentifier", (JsonSerializable)this.getSenderCommunicationIdentifier());
        jsonWriter.writeStringField("type", this.getType());
        jsonWriter.writeJsonField("recipientCommunicationIdentifier", (JsonSerializable)this.getRecipientCommunicationIdentifier());
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeStringField("senderDisplayName", this.getSenderDisplayName());
        jsonWriter.writeStringField("composeTime", this.getComposeTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getComposeTime()));
        jsonWriter.writeNumberField("version", (Number)this.getVersion());
        jsonWriter.writeStringField("messageBody", this.messageBody);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AcsChatMessageReceivedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatMessageReceivedEventData)jsonReader.readObject(reader -> {
            AcsChatMessageReceivedEventData deserializedAcsChatMessageReceivedEventData = new AcsChatMessageReceivedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("messageId".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setMessageId(reader.getString());
                    continue;
                }
                if ("senderCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setSenderCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setType(reader.getString());
                    continue;
                }
                if ("recipientCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setRecipientCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                    continue;
                }
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setThreadId(reader.getString());
                    continue;
                }
                if ("senderDisplayName".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setSenderDisplayName(reader.getString());
                    continue;
                }
                if ("composeTime".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setComposeTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.setVersion((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("messageBody".equals(fieldName)) {
                    deserializedAcsChatMessageReceivedEventData.messageBody = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedAcsChatMessageReceivedEventData.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatMessageReceivedEventData;
        });
    }
}

