/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ApiManagementExpiredGatewayTokenProperties
implements JsonSerializable<ApiManagementExpiredGatewayTokenProperties> {
    private OffsetDateTime expiresOn;

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public ApiManagementExpiredGatewayTokenProperties setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("expiredAtUtc", this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementExpiredGatewayTokenProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementExpiredGatewayTokenProperties)jsonReader.readObject(reader -> {
            ApiManagementExpiredGatewayTokenProperties deserializedApiManagementExpiredGatewayTokenProperties = new ApiManagementExpiredGatewayTokenProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("expiredAtUtc".equals(fieldName)) {
                    deserializedApiManagementExpiredGatewayTokenProperties.expiresOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementExpiredGatewayTokenProperties;
        });
    }
}

