/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.MediaJobState;
import java.io.IOException;
import java.util.Map;

public class MediaJobStateChangeEventData
implements JsonSerializable<MediaJobStateChangeEventData> {
    private MediaJobState previousState;
    private MediaJobState state;
    private Map<String, String> correlationData;

    public MediaJobState getPreviousState() {
        return this.previousState;
    }

    MediaJobStateChangeEventData setPreviousState(MediaJobState previousState) {
        this.previousState = previousState;
        return this;
    }

    public MediaJobState getState() {
        return this.state;
    }

    MediaJobStateChangeEventData setState(MediaJobState state) {
        this.state = state;
        return this;
    }

    public Map<String, String> getCorrelationData() {
        return this.correlationData;
    }

    public MediaJobStateChangeEventData setCorrelationData(Map<String, String> correlationData) {
        this.correlationData = correlationData;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("correlationData", this.correlationData, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static MediaJobStateChangeEventData fromJson(JsonReader jsonReader) throws IOException {
        return (MediaJobStateChangeEventData)jsonReader.readObject(reader -> {
            MediaJobStateChangeEventData deserializedMediaJobStateChangeEventData = new MediaJobStateChangeEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("previousState".equals(fieldName)) {
                    deserializedMediaJobStateChangeEventData.previousState = MediaJobState.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMediaJobStateChangeEventData.state = MediaJobState.fromString(reader.getString());
                    continue;
                }
                if ("correlationData".equals(fieldName)) {
                    Map correlationData;
                    deserializedMediaJobStateChangeEventData.correlationData = correlationData = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMediaJobStateChangeEventData;
        });
    }
}

