/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class ResourceAuthorization
implements JsonSerializable<ResourceAuthorization> {
    private String scope;
    private String action;
    private Map<String, String> evidence;

    public String getScope() {
        return this.scope;
    }

    public ResourceAuthorization setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getAction() {
        return this.action;
    }

    public ResourceAuthorization setAction(String action) {
        this.action = action;
        return this;
    }

    public Map<String, String> getEvidence() {
        return this.evidence;
    }

    public ResourceAuthorization setEvidence(Map<String, String> evidence) {
        this.evidence = evidence;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeStringField("action", this.action);
        jsonWriter.writeMapField("evidence", this.evidence, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceAuthorization)jsonReader.readObject(reader -> {
            ResourceAuthorization deserializedResourceAuthorization = new ResourceAuthorization();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    deserializedResourceAuthorization.scope = reader.getString();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedResourceAuthorization.action = reader.getString();
                    continue;
                }
                if ("evidence".equals(fieldName)) {
                    Map evidence;
                    deserializedResourceAuthorization.evidence = evidence = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceAuthorization;
        });
    }
}

