/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.StorageTaskAssignmentCompletedStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class StorageTaskAssignmentCompletedEventData
implements JsonSerializable<StorageTaskAssignmentCompletedEventData> {
    private StorageTaskAssignmentCompletedStatus status;
    private OffsetDateTime completedOn;
    private String taskExecutionId;
    private String taskName;
    private String summaryReportBlobUri;

    public StorageTaskAssignmentCompletedStatus getStatus() {
        return this.status;
    }

    public StorageTaskAssignmentCompletedEventData setStatus(StorageTaskAssignmentCompletedStatus status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime getCompletedOn() {
        return this.completedOn;
    }

    public StorageTaskAssignmentCompletedEventData setCompletedOn(OffsetDateTime completedOn) {
        this.completedOn = completedOn;
        return this;
    }

    public String getTaskExecutionId() {
        return this.taskExecutionId;
    }

    public StorageTaskAssignmentCompletedEventData setTaskExecutionId(String taskExecutionId) {
        this.taskExecutionId = taskExecutionId;
        return this;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public StorageTaskAssignmentCompletedEventData setTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    public String getSummaryReportBlobUri() {
        return this.summaryReportBlobUri;
    }

    public StorageTaskAssignmentCompletedEventData setSummaryReportBlobUri(String summaryReportBlobUri) {
        this.summaryReportBlobUri = summaryReportBlobUri;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("completedDateTime", this.completedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.completedOn));
        jsonWriter.writeStringField("taskExecutionId", this.taskExecutionId);
        jsonWriter.writeStringField("taskName", this.taskName);
        jsonWriter.writeStringField("summaryReportBlobUrl", this.summaryReportBlobUri);
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskAssignmentCompletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskAssignmentCompletedEventData)jsonReader.readObject(reader -> {
            StorageTaskAssignmentCompletedEventData deserializedStorageTaskAssignmentCompletedEventData = new StorageTaskAssignmentCompletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedStorageTaskAssignmentCompletedEventData.status = StorageTaskAssignmentCompletedStatus.fromString(reader.getString());
                    continue;
                }
                if ("completedDateTime".equals(fieldName)) {
                    deserializedStorageTaskAssignmentCompletedEventData.completedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("taskExecutionId".equals(fieldName)) {
                    deserializedStorageTaskAssignmentCompletedEventData.taskExecutionId = reader.getString();
                    continue;
                }
                if ("taskName".equals(fieldName)) {
                    deserializedStorageTaskAssignmentCompletedEventData.taskName = reader.getString();
                    continue;
                }
                if ("summaryReportBlobUrl".equals(fieldName)) {
                    deserializedStorageTaskAssignmentCompletedEventData.summaryReportBlobUri = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskAssignmentCompletedEventData;
        });
    }
}

