// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Message Channel Event Error.
 */
@Fluent
public final class AcsMessageChannelEventError implements JsonSerializable<AcsMessageChannelEventError> {
    /*
     * The channel error code
     */
    @Generated
    private String channelCode;

    /*
     * The channel error message
     */
    @Generated
    private String channelMessage;

    /**
     * Creates an instance of AcsMessageChannelEventError class.
     */
    @Generated
    public AcsMessageChannelEventError() {
    }

    /**
     * Get the channelCode property: The channel error code.
     * 
     * @return the channelCode value.
     */
    @Generated
    public String getChannelCode() {
        return this.channelCode;
    }

    /**
     * Set the channelCode property: The channel error code.
     * 
     * @param channelCode the channelCode value to set.
     * @return the AcsMessageChannelEventError object itself.
     */
    @Generated
    public AcsMessageChannelEventError setChannelCode(String channelCode) {
        this.channelCode = channelCode;
        return this;
    }

    /**
     * Get the channelMessage property: The channel error message.
     * 
     * @return the channelMessage value.
     */
    @Generated
    public String getChannelMessage() {
        return this.channelMessage;
    }

    /**
     * Set the channelMessage property: The channel error message.
     * 
     * @param channelMessage the channelMessage value to set.
     * @return the AcsMessageChannelEventError object itself.
     */
    @Generated
    public AcsMessageChannelEventError setChannelMessage(String channelMessage) {
        this.channelMessage = channelMessage;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("channelCode", this.channelCode);
        jsonWriter.writeStringField("channelMessage", this.channelMessage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsMessageChannelEventError from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsMessageChannelEventError if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsMessageChannelEventError.
     */
    @Generated
    public static AcsMessageChannelEventError fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsMessageChannelEventError deserializedAcsMessageChannelEventError = new AcsMessageChannelEventError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("channelCode".equals(fieldName)) {
                    deserializedAcsMessageChannelEventError.channelCode = reader.getString();
                } else if ("channelMessage".equals(fieldName)) {
                    deserializedAcsMessageChannelEventError.channelMessage = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsMessageChannelEventError;
        });
    }
}
