// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Router Communication Error.
 */
@Fluent
public final class AcsRouterCommunicationError implements JsonSerializable<AcsRouterCommunicationError> {
    /*
     * Router Communication Error Code
     */
    @Generated
    private String code;

    /*
     * Router Communication Error Message
     */
    @Generated
    private String message;

    /*
     * Router Communication Error Target
     */
    @Generated
    private String target;

    /*
     * Router Communication Inner Error
     */
    @Generated
    private AcsRouterCommunicationError innererror;

    /*
     * List of Router Communication Errors
     */
    @Generated
    private List<AcsRouterCommunicationError> details;

    /**
     * Creates an instance of AcsRouterCommunicationError class.
     */
    @Generated
    public AcsRouterCommunicationError() {
    }

    /**
     * Get the code property: Router Communication Error Code.
     * 
     * @return the code value.
     */
    @Generated
    public String getCode() {
        return this.code;
    }

    /**
     * Set the code property: Router Communication Error Code.
     * 
     * @param code the code value to set.
     * @return the AcsRouterCommunicationError object itself.
     */
    @Generated
    public AcsRouterCommunicationError setCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: Router Communication Error Message.
     * 
     * @return the message value.
     */
    @Generated
    public String getMessage() {
        return this.message;
    }

    /**
     * Set the message property: Router Communication Error Message.
     * 
     * @param message the message value to set.
     * @return the AcsRouterCommunicationError object itself.
     */
    @Generated
    public AcsRouterCommunicationError setMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the target property: Router Communication Error Target.
     * 
     * @return the target value.
     */
    @Generated
    public String getTarget() {
        return this.target;
    }

    /**
     * Set the target property: Router Communication Error Target.
     * 
     * @param target the target value to set.
     * @return the AcsRouterCommunicationError object itself.
     */
    @Generated
    public AcsRouterCommunicationError setTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Get the innererror property: Router Communication Inner Error.
     * 
     * @return the innererror value.
     */
    @Generated
    public AcsRouterCommunicationError getInnererror() {
        return this.innererror;
    }

    /**
     * Set the innererror property: Router Communication Inner Error.
     * 
     * @param innererror the innererror value to set.
     * @return the AcsRouterCommunicationError object itself.
     */
    @Generated
    public AcsRouterCommunicationError setInnererror(AcsRouterCommunicationError innererror) {
        this.innererror = innererror;
        return this;
    }

    /**
     * Get the details property: List of Router Communication Errors.
     * 
     * @return the details value.
     */
    @Generated
    public List<AcsRouterCommunicationError> getDetails() {
        return this.details;
    }

    /**
     * Set the details property: List of Router Communication Errors.
     * 
     * @param details the details value to set.
     * @return the AcsRouterCommunicationError object itself.
     */
    @Generated
    public AcsRouterCommunicationError setDetails(List<AcsRouterCommunicationError> details) {
        this.details = details;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeJsonField("innererror", this.innererror);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsRouterCommunicationError from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsRouterCommunicationError if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsRouterCommunicationError.
     */
    @Generated
    public static AcsRouterCommunicationError fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsRouterCommunicationError deserializedAcsRouterCommunicationError = new AcsRouterCommunicationError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedAcsRouterCommunicationError.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedAcsRouterCommunicationError.message = reader.getString();
                } else if ("target".equals(fieldName)) {
                    deserializedAcsRouterCommunicationError.target = reader.getString();
                } else if ("innererror".equals(fieldName)) {
                    deserializedAcsRouterCommunicationError.innererror = AcsRouterCommunicationError.fromJson(reader);
                } else if ("details".equals(fieldName)) {
                    List<AcsRouterCommunicationError> details
                        = reader.readArray(reader1 -> AcsRouterCommunicationError.fromJson(reader1));
                    deserializedAcsRouterCommunicationError.details = details;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsRouterCommunicationError;
        });
    }
}
