// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of calling event endedby properties.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsCallEndedByProperties implements JsonSerializable<AcsCallEndedByProperties> {

    /*
     * The communication identifier of the call ended by
     */
    @Generated
    private CommunicationIdentifierModel communicationIdentifier;

    /*
     * The type of the call ended by.
     */
    @Generated
    private AcsCallEndedByKind kind;

    /*
     * The name of the call ended by.
     */
    @Generated
    private String name;

    /**
     * Creates an instance of AcsCallEndedByProperties class.
     */
    @Generated
    public AcsCallEndedByProperties() {
    }

    /**
     * Get the communicationIdentifier property: The communication identifier of the call ended by.
     *
     * @return the communicationIdentifier value.
     */
    @Generated
    public CommunicationIdentifierModel getCommunicationIdentifier() {
        return this.communicationIdentifier;
    }

    /**
     * Set the communicationIdentifier property: The communication identifier of the call ended by.
     *
     * @param communicationIdentifier the communicationIdentifier value to set.
     * @return the AcsCallEndedByProperties object itself.
     */
    @Generated
    public AcsCallEndedByProperties setCommunicationIdentifier(CommunicationIdentifierModel communicationIdentifier) {
        this.communicationIdentifier = communicationIdentifier;
        return this;
    }

    /**
     * Get the kind property: The type of the call ended by.
     *
     * @return the kind value.
     */
    @Generated
    public AcsCallEndedByKind getKind() {
        return this.kind;
    }

    /**
     * Set the kind property: The type of the call ended by.
     *
     * @param kind the kind value to set.
     * @return the AcsCallEndedByProperties object itself.
     */
    @Generated
    public AcsCallEndedByProperties setKind(AcsCallEndedByKind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the name property: The name of the call ended by.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The name of the call ended by.
     *
     * @param name the name value to set.
     * @return the AcsCallEndedByProperties object itself.
     */
    @Generated
    public AcsCallEndedByProperties setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("communicationIdentifier", this.communicationIdentifier);
        jsonWriter.writeStringField("type", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsCallEndedByProperties from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsCallEndedByProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsCallEndedByProperties.
     */
    @Generated
    public static AcsCallEndedByProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsCallEndedByProperties deserializedAcsCallEndedByProperties = new AcsCallEndedByProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("communicationIdentifier".equals(fieldName)) {
                    deserializedAcsCallEndedByProperties.communicationIdentifier
                        = CommunicationIdentifierModel.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    deserializedAcsCallEndedByProperties.kind = AcsCallEndedByKind.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedAcsCallEndedByProperties.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsCallEndedByProperties;
        });
    }
}
