// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of common properties of participant events.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public class AcsCallParticipantEventData extends AcsCallingEventProperties {

    /*
     * The user of the call participant.
     */
    @Generated
    private AcsCallParticipantProperties user;

    /*
     * The display name of the participant.
     */
    @Generated
    private String displayName;

    /*
     * The Id of the participant.
     */
    @Generated
    private String participantId;

    /*
     * The user agent of the participant.
     */
    @Generated
    private String userAgent;

    /**
     * Creates an instance of AcsCallParticipantEventData class.
     */
    @Generated
    public AcsCallParticipantEventData() {
    }

    /**
     * Get the user property: The user of the call participant.
     *
     * @return the user value.
     */
    @Generated
    public AcsCallParticipantProperties getUser() {
        return this.user;
    }

    /**
     * Set the user property: The user of the call participant.
     *
     * @param user the user value to set.
     * @return the AcsCallParticipantEventData object itself.
     */
    @Generated
    public AcsCallParticipantEventData setUser(AcsCallParticipantProperties user) {
        this.user = user;
        return this;
    }

    /**
     * Get the displayName property: The display name of the participant.
     *
     * @return the displayName value.
     */
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the participant.
     *
     * @param displayName the displayName value to set.
     * @return the AcsCallParticipantEventData object itself.
     */
    @Generated
    public AcsCallParticipantEventData setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the participantId property: The Id of the participant.
     *
     * @return the participantId value.
     */
    @Generated
    public String getParticipantId() {
        return this.participantId;
    }

    /**
     * Set the participantId property: The Id of the participant.
     *
     * @param participantId the participantId value to set.
     * @return the AcsCallParticipantEventData object itself.
     */
    @Generated
    public AcsCallParticipantEventData setParticipantId(String participantId) {
        this.participantId = participantId;
        return this;
    }

    /**
     * Get the userAgent property: The user agent of the participant.
     *
     * @return the userAgent value.
     */
    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    /**
     * Set the userAgent property: The user agent of the participant.
     *
     * @param userAgent the userAgent value to set.
     * @return the AcsCallParticipantEventData object itself.
     */
    @Generated
    public AcsCallParticipantEventData setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantEventData setStartedBy(AcsCallParticipantProperties startedBy) {
        super.setStartedBy(startedBy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantEventData setServerCallId(String serverCallId) {
        super.setServerCallId(serverCallId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantEventData setGroup(AcsCallGroupProperties group) {
        super.setGroup(group);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantEventData setRoom(AcsCallRoomProperties room) {
        super.setRoom(room);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantEventData setIsTwoParty(Boolean isTwoParty) {
        super.setIsTwoParty(isTwoParty);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantEventData setCorrelationId(String correlationId) {
        super.setCorrelationId(correlationId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantEventData setIsRoomsCall(Boolean isRoomsCall) {
        super.setIsRoomsCall(isRoomsCall);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("startedBy", getStartedBy());
        jsonWriter.writeStringField("serverCallId", getServerCallId());
        jsonWriter.writeStringField("correlationId", getCorrelationId());
        jsonWriter.writeJsonField("group", getGroup());
        jsonWriter.writeJsonField("room", getRoom());
        jsonWriter.writeBooleanField("isTwoParty", isTwoParty());
        jsonWriter.writeBooleanField("isRoomsCall", isRoomsCall());
        jsonWriter.writeJsonField("user", this.user);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("participantId", this.participantId);
        jsonWriter.writeStringField("userAgent", this.userAgent);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsCallParticipantEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsCallParticipantEventData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsCallParticipantEventData.
     */
    @Generated
    public static AcsCallParticipantEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsCallParticipantEventData deserializedAcsCallParticipantEventData = new AcsCallParticipantEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startedBy".equals(fieldName)) {
                    deserializedAcsCallParticipantEventData.setStartedBy(AcsCallParticipantProperties.fromJson(reader));
                } else if ("serverCallId".equals(fieldName)) {
                    deserializedAcsCallParticipantEventData.setServerCallId(reader.getString());
                } else if ("correlationId".equals(fieldName)) {
                    deserializedAcsCallParticipantEventData.setCorrelationId(reader.getString());
                } else if ("group".equals(fieldName)) {
                    deserializedAcsCallParticipantEventData.setGroup(AcsCallGroupProperties.fromJson(reader));
                } else if ("room".equals(fieldName)) {
                    deserializedAcsCallParticipantEventData.setRoom(AcsCallRoomProperties.fromJson(reader));
                } else if ("isTwoParty".equals(fieldName)) {
                    deserializedAcsCallParticipantEventData.setIsTwoParty(reader.getNullable(JsonReader::getBoolean));
                } else if ("isRoomsCall".equals(fieldName)) {
                    deserializedAcsCallParticipantEventData.setIsRoomsCall(reader.getNullable(JsonReader::getBoolean));
                } else if ("user".equals(fieldName)) {
                    deserializedAcsCallParticipantEventData.user = AcsCallParticipantProperties.fromJson(reader);
                } else if ("displayName".equals(fieldName)) {
                    deserializedAcsCallParticipantEventData.displayName = reader.getString();
                } else if ("participantId".equals(fieldName)) {
                    deserializedAcsCallParticipantEventData.participantId = reader.getString();
                } else if ("userAgent".equals(fieldName)) {
                    deserializedAcsCallParticipantEventData.userAgent = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsCallParticipantEventData;
        });
    }
}
