// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of common properties of all thread-level chat events.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public class AcsChatEventInThreadBaseProperties implements JsonSerializable<AcsChatEventInThreadBaseProperties> {

    /*
     * The transaction id will be used as co-relation vector
     */
    @Generated
    private String transactionId;

    /*
     * The chat thread id
     */
    @Generated
    private String threadId;

    /**
     * Creates an instance of AcsChatEventInThreadBaseProperties class.
     */
    @Generated
    public AcsChatEventInThreadBaseProperties() {
    }

    /**
     * Get the transactionId property: The transaction id will be used as co-relation vector.
     *
     * @return the transactionId value.
     */
    @Generated
    public String getTransactionId() {
        return this.transactionId;
    }

    /**
     * Set the transactionId property: The transaction id will be used as co-relation vector.
     *
     * @param transactionId the transactionId value to set.
     * @return the AcsChatEventInThreadBaseProperties object itself.
     */
    @Generated
    public AcsChatEventInThreadBaseProperties setTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    /**
     * Get the threadId property: The chat thread id.
     *
     * @return the threadId value.
     */
    @Generated
    public String getThreadId() {
        return this.threadId;
    }

    /**
     * Set the threadId property: The chat thread id.
     *
     * @param threadId the threadId value to set.
     * @return the AcsChatEventInThreadBaseProperties object itself.
     */
    @Generated
    public AcsChatEventInThreadBaseProperties setThreadId(String threadId) {
        this.threadId = threadId;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", this.transactionId);
        jsonWriter.writeStringField("threadId", this.threadId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsChatEventInThreadBaseProperties from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsChatEventInThreadBaseProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsChatEventInThreadBaseProperties.
     */
    @Generated
    public static AcsChatEventInThreadBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsChatEventInThreadBaseProperties deserializedAcsChatEventInThreadBaseProperties
                = new AcsChatEventInThreadBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatEventInThreadBaseProperties.transactionId = reader.getString();
                } else if ("threadId".equals(fieldName)) {
                    deserializedAcsChatEventInThreadBaseProperties.threadId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsChatEventInThreadBaseProperties;
        });
    }
}
