// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatMessageEditedInThread event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsChatMessageEditedInThreadEventData extends AcsChatMessageEventInThreadBaseProperties {

    /*
     * The body of the chat message
     */
    @Generated
    private String messageBody;

    /*
     * The chat message metadata
     */
    @Generated
    private Map<String, String> metadata;

    /*
     * The time at which the message was edited
     */
    @Generated
    private OffsetDateTime editTime;

    /**
     * Creates an instance of AcsChatMessageEditedInThreadEventData class.
     */
    @Generated
    public AcsChatMessageEditedInThreadEventData() {
    }

    /**
     * Get the messageBody property: The body of the chat message.
     *
     * @return the messageBody value.
     */
    @Generated
    public String getMessageBody() {
        return this.messageBody;
    }

    /**
     * Set the messageBody property: The body of the chat message.
     *
     * @param messageBody the messageBody value to set.
     * @return the AcsChatMessageEditedInThreadEventData object itself.
     */
    @Generated
    public AcsChatMessageEditedInThreadEventData setMessageBody(String messageBody) {
        this.messageBody = messageBody;
        return this;
    }

    /**
     * Get the metadata property: The chat message metadata.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: The chat message metadata.
     *
     * @param metadata the metadata value to set.
     * @return the AcsChatMessageEditedInThreadEventData object itself.
     */
    @Generated
    public AcsChatMessageEditedInThreadEventData setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the editTime property: The time at which the message was edited.
     *
     * @return the editTime value.
     */
    @Generated
    public OffsetDateTime getEditTime() {
        return this.editTime;
    }

    /**
     * Set the editTime property: The time at which the message was edited.
     *
     * @param editTime the editTime value to set.
     * @return the AcsChatMessageEditedInThreadEventData object itself.
     */
    @Generated
    public AcsChatMessageEditedInThreadEventData setEditTime(OffsetDateTime editTime) {
        this.editTime = editTime;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatMessageEditedInThreadEventData setMessageId(String messageId) {
        super.setMessageId(messageId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatMessageEditedInThreadEventData
        setSenderCommunicationIdentifier(CommunicationIdentifierModel senderCommunicationIdentifier) {
        super.setSenderCommunicationIdentifier(senderCommunicationIdentifier);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatMessageEditedInThreadEventData setSenderDisplayName(String senderDisplayName) {
        super.setSenderDisplayName(senderDisplayName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatMessageEditedInThreadEventData setComposeTime(OffsetDateTime composeTime) {
        super.setComposeTime(composeTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatMessageEditedInThreadEventData setType(String type) {
        super.setType(type);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatMessageEditedInThreadEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatMessageEditedInThreadEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatMessageEditedInThreadEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", getTransactionId());
        jsonWriter.writeStringField("threadId", getThreadId());
        jsonWriter.writeStringField("messageId", getMessageId());
        jsonWriter.writeJsonField("senderCommunicationIdentifier", getSenderCommunicationIdentifier());
        jsonWriter.writeStringField("type", getType());
        jsonWriter.writeStringField("senderDisplayName", getSenderDisplayName());
        jsonWriter.writeStringField("composeTime",
            getComposeTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getComposeTime()));
        jsonWriter.writeNumberField("version", getVersion());
        jsonWriter.writeStringField("messageBody", this.messageBody);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("editTime",
            this.editTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.editTime));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsChatMessageEditedInThreadEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsChatMessageEditedInThreadEventData if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsChatMessageEditedInThreadEventData.
     */
    @Generated
    public static AcsChatMessageEditedInThreadEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsChatMessageEditedInThreadEventData deserializedAcsChatMessageEditedInThreadEventData
                = new AcsChatMessageEditedInThreadEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatMessageEditedInThreadEventData.setTransactionId(reader.getString());
                } else if ("threadId".equals(fieldName)) {
                    deserializedAcsChatMessageEditedInThreadEventData.setThreadId(reader.getString());
                } else if ("messageId".equals(fieldName)) {
                    deserializedAcsChatMessageEditedInThreadEventData.setMessageId(reader.getString());
                } else if ("senderCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageEditedInThreadEventData
                        .setSenderCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                } else if ("type".equals(fieldName)) {
                    deserializedAcsChatMessageEditedInThreadEventData.setType(reader.getString());
                } else if ("senderDisplayName".equals(fieldName)) {
                    deserializedAcsChatMessageEditedInThreadEventData.setSenderDisplayName(reader.getString());
                } else if ("composeTime".equals(fieldName)) {
                    deserializedAcsChatMessageEditedInThreadEventData.setComposeTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("version".equals(fieldName)) {
                    deserializedAcsChatMessageEditedInThreadEventData
                        .setVersion(reader.getNullable(JsonReader::getLong));
                } else if ("messageBody".equals(fieldName)) {
                    deserializedAcsChatMessageEditedInThreadEventData.messageBody = reader.getString();
                } else if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsChatMessageEditedInThreadEventData.metadata = metadata;
                } else if ("editTime".equals(fieldName)) {
                    deserializedAcsChatMessageEditedInThreadEventData.editTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsChatMessageEditedInThreadEventData;
        });
    }
}
