// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatParticipantAddedToThreadWithUser
 * event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsChatParticipantAddedToThreadWithUserEventData extends AcsChatThreadEventBaseProperties {

    /*
     * The time at which the user was added to the thread
     */
    @Generated
    private OffsetDateTime time;

    /*
     * The communication identifier of the user who added the user
     */
    @Generated
    private CommunicationIdentifierModel addedByCommunicationIdentifier;

    /*
     * The details of the user who was added
     */
    @Generated
    private AcsChatThreadParticipantProperties participantAdded;

    /**
     * Creates an instance of AcsChatParticipantAddedToThreadWithUserEventData class.
     */
    @Generated
    public AcsChatParticipantAddedToThreadWithUserEventData() {
    }

    /**
     * Get the time property: The time at which the user was added to the thread.
     *
     * @return the time value.
     */
    @Generated
    public OffsetDateTime getTime() {
        return this.time;
    }

    /**
     * Set the time property: The time at which the user was added to the thread.
     *
     * @param time the time value to set.
     * @return the AcsChatParticipantAddedToThreadWithUserEventData object itself.
     */
    @Generated
    public AcsChatParticipantAddedToThreadWithUserEventData setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    /**
     * Get the addedByCommunicationIdentifier property: The communication identifier of the user who added the user.
     *
     * @return the addedByCommunicationIdentifier value.
     */
    @Generated
    public CommunicationIdentifierModel getAddedByCommunicationIdentifier() {
        return this.addedByCommunicationIdentifier;
    }

    /**
     * Set the addedByCommunicationIdentifier property: The communication identifier of the user who added the user.
     *
     * @param addedByCommunicationIdentifier the addedByCommunicationIdentifier value to set.
     * @return the AcsChatParticipantAddedToThreadWithUserEventData object itself.
     */
    @Generated
    public AcsChatParticipantAddedToThreadWithUserEventData
        setAddedByCommunicationIdentifier(CommunicationIdentifierModel addedByCommunicationIdentifier) {
        this.addedByCommunicationIdentifier = addedByCommunicationIdentifier;
        return this;
    }

    /**
     * Get the participantAdded property: The details of the user who was added.
     *
     * @return the participantAdded value.
     */
    @Generated
    public AcsChatThreadParticipantProperties getParticipantAdded() {
        return this.participantAdded;
    }

    /**
     * Set the participantAdded property: The details of the user who was added.
     *
     * @param participantAdded the participantAdded value to set.
     * @return the AcsChatParticipantAddedToThreadWithUserEventData object itself.
     */
    @Generated
    public AcsChatParticipantAddedToThreadWithUserEventData
        setParticipantAdded(AcsChatThreadParticipantProperties participantAdded) {
        this.participantAdded = participantAdded;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatParticipantAddedToThreadWithUserEventData setCreateTime(OffsetDateTime createTime) {
        super.setCreateTime(createTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatParticipantAddedToThreadWithUserEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatParticipantAddedToThreadWithUserEventData
        setRecipientCommunicationIdentifier(CommunicationIdentifierModel recipientCommunicationIdentifier) {
        super.setRecipientCommunicationIdentifier(recipientCommunicationIdentifier);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatParticipantAddedToThreadWithUserEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatParticipantAddedToThreadWithUserEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("recipientCommunicationIdentifier", getRecipientCommunicationIdentifier());
        jsonWriter.writeStringField("transactionId", getTransactionId());
        jsonWriter.writeStringField("threadId", getThreadId());
        jsonWriter.writeStringField("createTime",
            getCreateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getCreateTime()));
        jsonWriter.writeNumberField("version", getVersion());
        jsonWriter.writeJsonField("addedByCommunicationIdentifier", this.addedByCommunicationIdentifier);
        jsonWriter.writeJsonField("participantAdded", this.participantAdded);
        jsonWriter.writeStringField("time",
            this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsChatParticipantAddedToThreadWithUserEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsChatParticipantAddedToThreadWithUserEventData if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsChatParticipantAddedToThreadWithUserEventData.
     */
    @Generated
    public static AcsChatParticipantAddedToThreadWithUserEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsChatParticipantAddedToThreadWithUserEventData deserializedAcsChatParticipantAddedToThreadWithUserEventData
                = new AcsChatParticipantAddedToThreadWithUserEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recipientCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData
                        .setRecipientCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                } else if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.setTransactionId(reader.getString());
                } else if ("threadId".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.setThreadId(reader.getString());
                } else if ("createTime".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.setCreateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("version".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData
                        .setVersion(reader.getNullable(JsonReader::getLong));
                } else if ("addedByCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.addedByCommunicationIdentifier
                        = CommunicationIdentifierModel.fromJson(reader);
                } else if ("participantAdded".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.participantAdded
                        = AcsChatThreadParticipantProperties.fromJson(reader);
                } else if ("time".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.time = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsChatParticipantAddedToThreadWithUserEventData;
        });
    }
}
