// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Message Context.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsMessageContext implements JsonSerializable<AcsMessageContext> {

    /*
     * The WhatsApp ID for the customer who replied to an inbound message.
     */
    @Generated
    private String from;

    /*
     * The message ID for the sent message for an inbound reply
     */
    @Generated
    private String messageId;

    /**
     * Creates an instance of AcsMessageContext class.
     */
    @Generated
    public AcsMessageContext() {
    }

    /**
     * Get the from property: The WhatsApp ID for the customer who replied to an inbound message.
     *
     * @return the from value.
     */
    @Generated
    public String getFrom() {
        return this.from;
    }

    /**
     * Set the from property: The WhatsApp ID for the customer who replied to an inbound message.
     *
     * @param from the from value to set.
     * @return the AcsMessageContext object itself.
     */
    @Generated
    public AcsMessageContext setFrom(String from) {
        this.from = from;
        return this;
    }

    /**
     * Get the messageId property: The message ID for the sent message for an inbound reply.
     *
     * @return the messageId value.
     */
    @Generated
    public String getMessageId() {
        return this.messageId;
    }

    /**
     * Set the messageId property: The message ID for the sent message for an inbound reply.
     *
     * @param messageId the messageId value to set.
     * @return the AcsMessageContext object itself.
     */
    @Generated
    public AcsMessageContext setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("from", this.from);
        jsonWriter.writeStringField("id", this.messageId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsMessageContext from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsMessageContext if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsMessageContext.
     */
    @Generated
    public static AcsMessageContext fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsMessageContext deserializedAcsMessageContext = new AcsMessageContext();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("from".equals(fieldName)) {
                    deserializedAcsMessageContext.from = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedAcsMessageContext.messageId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsMessageContext;
        });
    }
}
