// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Schema for all properties of Recording Storage Information.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsRecordingStorageInfoProperties implements JsonSerializable<AcsRecordingStorageInfoProperties> {

    /*
     * List of details of recording chunks information
     */
    @Generated
    private List<AcsRecordingChunkInfoProperties> recordingChunks;

    /**
     * Creates an instance of AcsRecordingStorageInfoProperties class.
     */
    @Generated
    public AcsRecordingStorageInfoProperties() {
    }

    /**
     * Get the recordingChunks property: List of details of recording chunks information.
     *
     * @return the recordingChunks value.
     */
    @Generated
    public List<AcsRecordingChunkInfoProperties> getRecordingChunks() {
        return this.recordingChunks;
    }

    /**
     * Set the recordingChunks property: List of details of recording chunks information.
     *
     * @param recordingChunks the recordingChunks value to set.
     * @return the AcsRecordingStorageInfoProperties object itself.
     */
    @Generated
    public AcsRecordingStorageInfoProperties setRecordingChunks(List<AcsRecordingChunkInfoProperties> recordingChunks) {
        this.recordingChunks = recordingChunks;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("recordingChunks", this.recordingChunks,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsRecordingStorageInfoProperties from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsRecordingStorageInfoProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsRecordingStorageInfoProperties.
     */
    @Generated
    public static AcsRecordingStorageInfoProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsRecordingStorageInfoProperties deserializedAcsRecordingStorageInfoProperties
                = new AcsRecordingStorageInfoProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recordingChunks".equals(fieldName)) {
                    List<AcsRecordingChunkInfoProperties> recordingChunks
                        = reader.readArray(reader1 -> AcsRecordingChunkInfoProperties.fromJson(reader1));
                    deserializedAcsRecordingStorageInfoProperties.recordingChunks = recordingChunks;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsRecordingStorageInfoProperties;
        });
    }
}
