// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterJobDeleted event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsRouterJobDeletedEventData extends AcsRouterJobEventData {

    /**
     * Creates an instance of AcsRouterJobDeletedEventData class.
     */
    @Generated
    public AcsRouterJobDeletedEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobDeletedEventData setQueueId(String queueId) {
        super.setQueueId(queueId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobDeletedEventData setLabels(Map<String, String> labels) {
        super.setLabels(labels);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobDeletedEventData setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobDeletedEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobDeletedEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobDeletedEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("labels", getLabels(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("tags", getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("jobId", getJobId());
        jsonWriter.writeStringField("channelReference", getChannelReference());
        jsonWriter.writeStringField("channelId", getChannelId());
        jsonWriter.writeStringField("queueId", getQueueId());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsRouterJobDeletedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsRouterJobDeletedEventData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsRouterJobDeletedEventData.
     */
    @Generated
    public static AcsRouterJobDeletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsRouterJobDeletedEventData deserializedAcsRouterJobDeletedEventData = new AcsRouterJobDeletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("labels".equals(fieldName)) {
                    Map<String, String> labels = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobDeletedEventData.setLabels(labels);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobDeletedEventData.setTags(tags);
                } else if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterJobDeletedEventData.setJobId(reader.getString());
                } else if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterJobDeletedEventData.setChannelReference(reader.getString());
                } else if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterJobDeletedEventData.setChannelId(reader.getString());
                } else if ("queueId".equals(fieldName)) {
                    deserializedAcsRouterJobDeletedEventData.setQueueId(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsRouterJobDeletedEventData;
        });
    }
}
