// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterJobWaitingForActivation event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsRouterJobWaitingForActivationEventData extends AcsRouterJobEventData {

    /*
     * Router Job Waiting For Activation Priority
     */
    @Generated
    private Integer priority;

    /*
     * Router Job Waiting For Activation Worker Selector Expired
     */
    @Generated
    private List<AcsRouterWorkerSelector> expiredAttachedWorkerSelectors;

    /*
     * Router Job Waiting For Activation Requested Worker Selector Expired
     */
    @Generated
    private List<AcsRouterWorkerSelector> expiredRequestedWorkerSelectors;

    /*
     * Router Job Waiting For Activation Scheduled Time in UTC
     */
    @Generated
    private OffsetDateTime scheduledOn;

    /*
     * Router Job Waiting For Activation Unavailable For Matching
     */
    @Generated
    private boolean unavailableForMatching;

    /**
     * Creates an instance of AcsRouterJobWaitingForActivationEventData class.
     */
    @Generated
    public AcsRouterJobWaitingForActivationEventData() {
    }

    /**
     * Get the priority property: Router Job Waiting For Activation Priority.
     *
     * @return the priority value.
     */
    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    /**
     * Set the priority property: Router Job Waiting For Activation Priority.
     *
     * @param priority the priority value to set.
     * @return the AcsRouterJobWaitingForActivationEventData object itself.
     */
    @Generated
    public AcsRouterJobWaitingForActivationEventData setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the expiredAttachedWorkerSelectors property: Router Job Waiting For Activation Worker Selector Expired.
     *
     * @return the expiredAttachedWorkerSelectors value.
     */
    @Generated
    public List<AcsRouterWorkerSelector> getExpiredAttachedWorkerSelectors() {
        return this.expiredAttachedWorkerSelectors;
    }

    /**
     * Set the expiredAttachedWorkerSelectors property: Router Job Waiting For Activation Worker Selector Expired.
     *
     * @param expiredAttachedWorkerSelectors the expiredAttachedWorkerSelectors value to set.
     * @return the AcsRouterJobWaitingForActivationEventData object itself.
     */
    @Generated
    public AcsRouterJobWaitingForActivationEventData
        setExpiredAttachedWorkerSelectors(List<AcsRouterWorkerSelector> expiredAttachedWorkerSelectors) {
        this.expiredAttachedWorkerSelectors = expiredAttachedWorkerSelectors;
        return this;
    }

    /**
     * Get the expiredRequestedWorkerSelectors property: Router Job Waiting For Activation Requested Worker Selector
     * Expired.
     *
     * @return the expiredRequestedWorkerSelectors value.
     */
    @Generated
    public List<AcsRouterWorkerSelector> getExpiredRequestedWorkerSelectors() {
        return this.expiredRequestedWorkerSelectors;
    }

    /**
     * Set the expiredRequestedWorkerSelectors property: Router Job Waiting For Activation Requested Worker Selector
     * Expired.
     *
     * @param expiredRequestedWorkerSelectors the expiredRequestedWorkerSelectors value to set.
     * @return the AcsRouterJobWaitingForActivationEventData object itself.
     */
    @Generated
    public AcsRouterJobWaitingForActivationEventData
        setExpiredRequestedWorkerSelectors(List<AcsRouterWorkerSelector> expiredRequestedWorkerSelectors) {
        this.expiredRequestedWorkerSelectors = expiredRequestedWorkerSelectors;
        return this;
    }

    /**
     * Get the scheduledOn property: Router Job Waiting For Activation Scheduled Time in UTC.
     *
     * @return the scheduledOn value.
     */
    @Generated
    public OffsetDateTime getScheduledOn() {
        return this.scheduledOn;
    }

    /**
     * Set the scheduledOn property: Router Job Waiting For Activation Scheduled Time in UTC.
     *
     * @param scheduledOn the scheduledOn value to set.
     * @return the AcsRouterJobWaitingForActivationEventData object itself.
     */
    @Generated
    public AcsRouterJobWaitingForActivationEventData setScheduledOn(OffsetDateTime scheduledOn) {
        this.scheduledOn = scheduledOn;
        return this;
    }

    /**
     * Get the unavailableForMatching property: Router Job Waiting For Activation Unavailable For Matching.
     *
     * @return the unavailableForMatching value.
     */
    @Generated
    public Boolean isUnavailableForMatching() {
        return this.unavailableForMatching;
    }

    /**
     * Set the unavailableForMatching property: Router Job Waiting For Activation Unavailable For Matching.
     *
     * @param unavailableForMatching the unavailableForMatching value to set.
     * @return the AcsRouterJobWaitingForActivationEventData object itself.
     */
    @Generated
    public AcsRouterJobWaitingForActivationEventData setUnavailableForMatching(Boolean unavailableForMatching) {
        this.unavailableForMatching = unavailableForMatching;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobWaitingForActivationEventData setQueueId(String queueId) {
        super.setQueueId(queueId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobWaitingForActivationEventData setLabels(Map<String, String> labels) {
        super.setLabels(labels);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobWaitingForActivationEventData setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobWaitingForActivationEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobWaitingForActivationEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobWaitingForActivationEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("labels", getLabels(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("tags", getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("jobId", getJobId());
        jsonWriter.writeStringField("channelReference", getChannelReference());
        jsonWriter.writeStringField("channelId", getChannelId());
        jsonWriter.writeStringField("queueId", getQueueId());
        jsonWriter.writeBooleanField("unavailableForMatching", this.unavailableForMatching);
        jsonWriter.writeNumberField("priority", this.priority);
        jsonWriter.writeArrayField("expiredAttachedWorkerSelectors", this.expiredAttachedWorkerSelectors,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("expiredRequestedWorkerSelectors", this.expiredRequestedWorkerSelectors,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("scheduledOn",
            this.scheduledOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.scheduledOn));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsRouterJobWaitingForActivationEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsRouterJobWaitingForActivationEventData if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsRouterJobWaitingForActivationEventData.
     */
    @Generated
    public static AcsRouterJobWaitingForActivationEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsRouterJobWaitingForActivationEventData deserializedAcsRouterJobWaitingForActivationEventData
                = new AcsRouterJobWaitingForActivationEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("labels".equals(fieldName)) {
                    Map<String, String> labels = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobWaitingForActivationEventData.setLabels(labels);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobWaitingForActivationEventData.setTags(tags);
                } else if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterJobWaitingForActivationEventData.setJobId(reader.getString());
                } else if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterJobWaitingForActivationEventData.setChannelReference(reader.getString());
                } else if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterJobWaitingForActivationEventData.setChannelId(reader.getString());
                } else if ("queueId".equals(fieldName)) {
                    deserializedAcsRouterJobWaitingForActivationEventData.setQueueId(reader.getString());
                } else if ("unavailableForMatching".equals(fieldName)) {
                    deserializedAcsRouterJobWaitingForActivationEventData.unavailableForMatching = reader.getBoolean();
                } else if ("priority".equals(fieldName)) {
                    deserializedAcsRouterJobWaitingForActivationEventData.priority
                        = reader.getNullable(JsonReader::getInt);
                } else if ("expiredAttachedWorkerSelectors".equals(fieldName)) {
                    List<AcsRouterWorkerSelector> expiredAttachedWorkerSelectors
                        = reader.readArray(reader1 -> AcsRouterWorkerSelector.fromJson(reader1));
                    deserializedAcsRouterJobWaitingForActivationEventData.expiredAttachedWorkerSelectors
                        = expiredAttachedWorkerSelectors;
                } else if ("expiredRequestedWorkerSelectors".equals(fieldName)) {
                    List<AcsRouterWorkerSelector> expiredRequestedWorkerSelectors
                        = reader.readArray(reader1 -> AcsRouterWorkerSelector.fromJson(reader1));
                    deserializedAcsRouterJobWaitingForActivationEventData.expiredRequestedWorkerSelectors
                        = expiredRequestedWorkerSelectors;
                } else if ("scheduledOn".equals(fieldName)) {
                    deserializedAcsRouterJobWaitingForActivationEventData.scheduledOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsRouterJobWaitingForActivationEventData;
        });
    }
}
