// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Router Queue Details.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsRouterQueueDetails implements JsonSerializable<AcsRouterQueueDetails> {

    /*
     * Router Queue Id
     */
    @Generated
    private String id;

    /*
     * Router Queue Name
     */
    @Generated
    private String name;

    /*
     * Router Queue Labels
     */
    @Generated
    private Map<String, String> labels;

    /**
     * Creates an instance of AcsRouterQueueDetails class.
     */
    @Generated
    public AcsRouterQueueDetails() {
    }

    /**
     * Get the id property: Router Queue Id.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: Router Queue Id.
     *
     * @param id the id value to set.
     * @return the AcsRouterQueueDetails object itself.
     */
    @Generated
    public AcsRouterQueueDetails setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: Router Queue Name.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: Router Queue Name.
     *
     * @param name the name value to set.
     * @return the AcsRouterQueueDetails object itself.
     */
    @Generated
    public AcsRouterQueueDetails setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the labels property: Router Queue Labels.
     *
     * @return the labels value.
     */
    @Generated
    public Map<String, String> getLabels() {
        return this.labels;
    }

    /**
     * Set the labels property: Router Queue Labels.
     *
     * @param labels the labels value to set.
     * @return the AcsRouterQueueDetails object itself.
     */
    @Generated
    public AcsRouterQueueDetails setLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeMapField("labels", this.labels, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsRouterQueueDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsRouterQueueDetails if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsRouterQueueDetails.
     */
    @Generated
    public static AcsRouterQueueDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsRouterQueueDetails deserializedAcsRouterQueueDetails = new AcsRouterQueueDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAcsRouterQueueDetails.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAcsRouterQueueDetails.name = reader.getString();
                } else if ("labels".equals(fieldName)) {
                    Map<String, String> labels = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterQueueDetails.labels = labels;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsRouterQueueDetails;
        });
    }
}
