// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterWorkerDeleted event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsRouterWorkerDeletedEventData extends AcsRouterWorkerEventData {

    /**
     * Creates an instance of AcsRouterWorkerDeletedEventData class.
     */
    @Generated
    public AcsRouterWorkerDeletedEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterWorkerDeletedEventData setWorkerId(String workerId) {
        super.setWorkerId(workerId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterWorkerDeletedEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterWorkerDeletedEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterWorkerDeletedEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobId", getJobId());
        jsonWriter.writeStringField("channelReference", getChannelReference());
        jsonWriter.writeStringField("channelId", getChannelId());
        jsonWriter.writeStringField("workerId", getWorkerId());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsRouterWorkerDeletedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsRouterWorkerDeletedEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsRouterWorkerDeletedEventData.
     */
    @Generated
    public static AcsRouterWorkerDeletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsRouterWorkerDeletedEventData deserializedAcsRouterWorkerDeletedEventData
                = new AcsRouterWorkerDeletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterWorkerDeletedEventData.setJobId(reader.getString());
                } else if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterWorkerDeletedEventData.setChannelReference(reader.getString());
                } else if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterWorkerDeletedEventData.setChannelId(reader.getString());
                } else if ("workerId".equals(fieldName)) {
                    deserializedAcsRouterWorkerDeletedEventData.setWorkerId(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsRouterWorkerDeletedEventData;
        });
    }
}
